/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import snaq.util.Cacheable;

public class TimeWrapper
implements Cacheable {
    private Object id;
    private Object obj;
    private long death = 0L;
    private long accessed = System.currentTimeMillis();

    public TimeWrapper(Object object, Object object2, long l) {
        this.id = object;
        this.obj = object2;
        if (l > 0L) {
            this.death = System.currentTimeMillis() + l;
        }
    }

    public Object getId() {
        return this.id;
    }

    public Object getObject() {
        return this.obj;
    }

    synchronized void setLiveTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid expiry time");
        }
        this.death = l > 0L ? System.currentTimeMillis() + l : 0L;
    }

    public synchronized boolean isExpired() {
        return this.death > 0L && System.currentTimeMillis() > this.death;
    }

    synchronized void updateAccessed() {
        this.accessed = System.currentTimeMillis();
    }

    long getAccessed() {
        return this.accessed;
    }
}

