/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = "\\pard".getBytes();
    protected static final byte[] IN_TABLE = "\\intbl".getBytes();
    protected ArrayList chunks = new ArrayList();

    public RtfPhrase(RtfDocument doc, Phrase phrase) {
        super(doc);
        if (phrase == null) {
            return;
        }
        ArrayList origChunks = phrase.getChunks();
        for (int i = 0; i < origChunks.size(); ++i) {
            Chunk chunk = (Chunk)origChunks.get(i);
            chunk.setFont(phrase.font().difference(chunk.font()));
            try {
                this.chunks.add(doc.getMapper().mapElement(chunk));
                continue;
            }
            catch (DocumentException de) {
                // empty catch block
            }
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                result.write(IN_TABLE);
            }
            for (int i = 0; i < this.chunks.size(); ++i) {
                result.write(((RtfBasicElement)this.chunks.get(i)).write());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setInTable(inTable);
        }
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setInHeader(inHeader);
        }
    }

    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setRtfDocument(this.document);
        }
    }
}

