/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;

public class PdfBarcode
extends Chunk {
    public static final int CODE39 = 1;
    public static final int UPCA = 2;
    public static final int EAN13 = 3;
    public static final int INTERLEAVED_2_OF_5 = 4;
    public static final int[][] variableParity = new int[][]{{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 0, 1, 1, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 0, 1, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 0, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 0, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 1, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 1, 1, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 0, 1, 0, 2, 2, 2, 2, 2, 2}};

    public PdfBarcode(String ttf, int type, int size, String number) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(type, number), new Font(BaseFont.createFont(ttf, "winansi", true), (float)size));
    }

    public PdfBarcode(String ttf, int type, int size, long number) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(type, String.valueOf(number)), new Font(BaseFont.createFont(ttf, "winansi", true), (float)size));
    }

    private static String convertToCode(int type, String number) throws BadElementException {
        StringBuffer code = new StringBuffer();
        int length = number.length();
        int pos = 0;
        try {
            switch (type) {
                case 1: {
                    code.append('*');
                    while (pos < length) {
                        code.append(number.substring(pos++, pos));
                    }
                    code.append('*');
                    break;
                }
                case 2: {
                    if (length > 12) {
                        throw new BadElementException("An UPC-A barcode can only encode a 12 digit number (your number was " + number + ").");
                    }
                    number = PdfBarcode.addZero(number, 12);
                    int digit = Integer.parseInt(number.substring(pos++, pos));
                    code.append((char)(digit + 80));
                    while (pos < 6) {
                        digit = Integer.parseInt(number.substring(pos++, pos));
                        code.append((char)(digit + 48));
                    }
                    code.append('p');
                    while (pos < 11) {
                        digit = Integer.parseInt(number.substring(pos++, pos));
                        code.append((char)(digit + 64));
                    }
                    digit = Integer.parseInt(number.substring(11));
                    code.append((char)(digit + 96));
                    break;
                }
                case 3: {
                    if (length > 13) {
                        throw new BadElementException("An EAN-13 barcode can only encode a 13 digit number (your number was " + number + ").");
                    }
                    number = PdfBarcode.addZero(number, 13);
                    int firstdigit = Integer.parseInt(number.substring(pos++, pos));
                    code.append((char)(firstdigit + 33));
                    int digit = Integer.parseInt(number.substring(pos++, pos));
                    code.append((char)(digit + 96));
                    while (pos < 7) {
                        digit = Integer.parseInt(number.substring(pos++, pos));
                        code.append((char)(digit + 48 + 16 * variableParity[firstdigit][pos - 2]));
                    }
                    code.append('|');
                    while (pos < 12) {
                        digit = Integer.parseInt(number.substring(pos++, pos));
                        code.append((char)(digit + 48 + 16 * variableParity[firstdigit][pos - 2]));
                    }
                    digit = Integer.parseInt(number.substring(12));
                    code.append((char)(digit + 112));
                    break;
                }
                case 4: {
                    int digit;
                    if (length % 2 == 1) {
                        number = PdfBarcode.addZero(number, length + 1);
                    }
                    code.append('(');
                    while (number.length() > 2) {
                        digit = Integer.parseInt(number.substring(0, 2));
                        code.append(PdfBarcode.convertInterleaved(digit));
                        pos += 2;
                        number = number.substring(2);
                    }
                    digit = Integer.parseInt(number);
                    code.append(PdfBarcode.convertInterleaved(digit));
                    code.append(')');
                    break;
                }
                default: {
                    throw new BadElementException("This type of barcode is not supported yet: " + type);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new BadElementException("NumberFormatException at position " + pos + " in " + number + ": " + nfe.getMessage());
        }
        return code.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static char convertInterleaved(int digits) throws NumberFormatException {
        void var1_1;
        int i;
        if (digits < 50) {
            i = 48;
        } else if (digits < 100) {
            i = 142;
        } else {
            throw new NumberFormatException(String.valueOf(digits));
        }
        return (char)(digits + var1_1);
    }

    private static String addZero(String number, int length) {
        StringBuffer buf = new StringBuffer();
        int zeros = length - number.length();
        for (int i = 0; i < zeros; ++i) {
            buf.append('0');
        }
        buf.append(number);
        return buf.toString();
    }
}

