--
-- kOOL - the church tool
-- www.churchtool.org
--
-- DB changes needed for update from R43 to R44
-- Important: Update DB before updating source
--


ALTER TABLE `ko_tracking` DROP `date_mode`;

ALTER TABLE `ko_leute_mod` CHANGE `geschlecht` `geschlecht` ENUM('', 'm', 'w') NOT NULL;

ALTER TABLE `ko_tracking_entries` ADD `comment` TEXT NOT NULL;

CREATE TABLE `ko_scheduler_tasks` (
	`id` MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	`name` VARCHAR( 200 ) NOT NULL ,
	`crontime` VARCHAR( 200 ) NOT NULL ,
	`status` INT UNSIGNED NOT NULL ,
	`call` TEXT NOT NULL ,
	`last_call` DATETIME NOT NULL ,
	`next_call` DATETIME NOT NULL
);
INSERT INTO `ko_scheduler_tasks` (`id`, `name`, `crontime`, `status`, `call`, `last_call`, `next_call`) VALUES (3, 'Delete old downloads', '47 2 * * *', 0, 'ko_task_delete_old_downloads', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

INSERT INTO `ko_settings` (`key`, `value`) VALUES ('typo3_host', ''), ('typo3_db', ''), ('typo3_user', ''), ('typo3_pwd', '');

INSERT INTO `ko_filter` ( `id` , `typ` , `dbcol` , `name` , `group` , `allow_neg` , `sql1` , `sql2` , `sql3` , `numvars` , `var1` , `code1` , `var2` , `code2` , `var3` , `code3`) VALUES ( NULL , 'leute', '', 'dobrange', 'status', '1', 'geburtsdatum >= ''[VAR1]''', 'geburtsdatum <= ''[VAR2]''', '', '2', 'lower', '<input type="text" name="var1" size="12" maxlength="10" />', 'upper', '<input type="text" name="var2" size="12" maxlength="10" />', '', '');

INSERT INTO `ko_settings` (`key`, `value`) VALUES ('mailing_allow_double', '0');

ALTER TABLE `ko_leute_mod` CHANGE `_group_id` `_group_id` TINYTEXT NOT NULL;
UPDATE `ko_leute_mod` SET `_group_id` = '' WHERE `_group_id` IS NULL;
ALTER TABLE `ko_leute_mod` CHANGE `vorname` `vorname` VARCHAR(100) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `nachname` `nachname` VARCHAR(100) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `adresse` `adresse` VARCHAR(100) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `adresse_zusatz` `adresse_zusatz` VARCHAR(100) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `plz` `plz` VARCHAR(20) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `ort` `ort` VARCHAR(100) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `land` `land` VARCHAR(100) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `telp` `telp` VARCHAR(30) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `telg` `telg` VARCHAR(30) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `natel` `natel` VARCHAR(30) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `fax` `fax` VARCHAR(30) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `email` `email` VARCHAR(100) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `web` `web` VARCHAR(100) NOT NULL;
ALTER TABLE `ko_leute_mod` CHANGE `geburtsdatum` `geburtsdatum` DATE NOT NULL;


ALTER TABLE `ko_eventgruppen` ADD `ical_url` VARCHAR( 255 ) NOT NULL;
ALTER TABLE `ko_eventgruppen` ADD `update` INT NOT NULL, ADD `last_update` DATETIME NOT NULL;


INSERT INTO `ko_scheduler_tasks` ( `id` , `name` , `crontime` , `status` , `call` , `last_call` , `next_call`) VALUES ( NULL , 'iCal import', '*/5 * * * *', '1', 'ko_task_import_events_ical', '', '');

INSERT INTO `ko_settings` ( `key` , `value`) VALUES ( 'res_show_purpose', '1');

ALTER TABLE `ko_event` ADD `title` VARCHAR( 255 ) NOT NULL AFTER `endzeit`;
ALTER TABLE `ko_event_mod` ADD `title` VARCHAR( 255 ) NOT NULL AFTER `endzeit`;

INSERT INTO `ko_settings` ( `key`, `value`) VALUES ('leute_real_delete', '0');

ALTER TABLE `ko_tracking_entries` ADD `status` tinyint unsigned NOT NULL;
ALTER TABLE `ko_tracking_entries` ADD `crdate` datetime NOT NULL;
ALTER TABLE `ko_tracking_entries` ADD `cruser` mediumint(9) unsigned NOT NULL;
ALTER TABLE `ko_tracking_entries` ADD `last_change` datetime NOT NULL;

INSERT INTO `ko_help` (`module`, `type`, `language`, `t3_page`, `t3_content`, `text`) VALUES ('donations', 'submenu_filter_amount', 'en', '', '', '<h1>Filter for the amount:</h1><ul><li><b>100-200</b>: Find amount between 100 and 200 (including)</li><li><b>&gt;100</b>: Amount greater than or equal to 100</li><li><b>&lt;100</b>: Amount smaller than or equal to 100</li><li><b>=100</b>: Amount is exactly 100</li><li><b>Other values</b>: Partial matches: "100" finds "100", "1000" and e.g. "1009"</li></ul>');
INSERT INTO `ko_help` (`module`, `type`, `language`, `t3_page`, `t3_content`, `text`) VALUES ('donations', 'submenu_filter_amount', 'de', '', '', '<h1>Suche nach Betrag:</h1><ul><li><b>100-200</b>: Betrag zwischen 100 und 200 (inklusive)</li><li><b>&gt;100</b>: Betrag grsser als 100 (inklusive)</li><li><b>&lt;100</b>: Betrag kleiner als 100 (inklusive)</li><li><b>=100</b>: Betrag exakt 100</li><li><b>Sonstige Eingaben</b>: Teilsuche, z.B. "100" findet "100" aber auch "1000" oder "1009"</li></ul>');

INSERT INTO `ko_filter` (`id`, `typ`, `dbcol`, `name`, `group`, `allow_neg`, `sql1`, `sql2`, `sql3`, `numvars`, `var1`, `code1`, `var2`, `code2`, `var3`, `code3`) VALUES (NULL, 'leute', 'id', 'id', 'misc', 0, 'id = ''[VAR1]''', '', '', 1, 'id', '<input type="text" name="var1" size="12" maxlength="11" onkeydown="if ((event.which == 13) || (event.keyCode == 13)) { this.form.submit_filter.click(); return false;} else return true;" />', '', '', '', '');

INSERT INTO `ko_filter` (`id`, `typ`, `dbcol`, `name`, `group`, `allow_neg`, `sql1`, `sql2`, `sql3`, `numvars`, `var1`, `code1`, `var2`, `code2`, `var3`, `code3`) VALUES (NULL, 'leute', 'hidden', 'hidden', 'status', 0, '`hidden` = ''1''', '', '', 1, 'hidden', '<input type="checkbox" name="var1" checked="checked" value="1" disabled="disabled" />', '', '', '', '');

ALTER TABLE `ko_event` CHANGE `eventgruppen_id` `eventgruppen_id` MEDIUMINT( 9 ) NOT NULL;
ALTER TABLE `ko_event` CHANGE `startdatum` `startdatum` DATE NOT NULL;
ALTER TABLE `ko_event` CHANGE `enddatum` `enddatum` DATE NOT NULL;
ALTER TABLE `ko_event` CHANGE `startzeit` `startzeit` TIME NOT NULL;
ALTER TABLE `ko_event` CHANGE `endzeit` `endzeit` TIME NOT NULL;
ALTER TABLE `ko_event` CHANGE `room` `room` VARCHAR( 200 ) NOT NULL;
ALTER TABLE `ko_event` CHANGE `kommentar` `kommentar` TEXT NOT NULL;
ALTER TABLE `ko_event` CHANGE `kommentar2` `kommentar2` TEXT NOT NULL;
ALTER TABLE `ko_event` CHANGE `reservationen` `reservationen` TEXT NOT NULL;
ALTER TABLE `ko_event` CHANGE `url` `url` TINYTEXT NOT NULL;

UPDATE `ko_filter` SET `numvars` = '2', `var2` = 'teams', `code2` = 'FCN:ko_specialfilter_rota_teams' WHERE `name` = 'rota';

UPDATE `ko_settings` SET `key` = 'ps_filter_sel_ds1_koi[ko_donations][person]' WHERE `key` = 'ps_filter_sel_ds1_koi[ko_donations][person][0]';

ALTER TABLE `ko_groups` ADD `maxcount` MEDIUMINT NOT NULL , ADD `count` MEDIUMINT NOT NULL , ADD `count_role` TEXT NOT NULL;

ALTER TABLE `ko_pdf_layout` ADD `type` VARCHAR( 50 ) NOT NULL AFTER `id`;
UPDATE `ko_pdf_layout` SET `type` = 'leute';

ALTER TABLE `ko_groups` ADD `mailing_mod_role` VARCHAR(15) NOT NULL, ADD `mailing_mod_logins` SMALLINT NOT NULL, ADD `mailing_mod_members` SMALLINT NOT NULL, ADD `mailing_mod_others` SMALLINT NOT NULL;

ALTER TABLE `ko_mailing_mails` ADD `sender_email` VARCHAR( 250 ) NOT NULL;

ALTER TABLE `ko_eventgruppen` ADD `title` VARCHAR(255) NOT NULL AFTER `endzeit`;

INSERT INTO  `ko_help` ( `id` , `module` , `type` , `language` , `t3_page` , `t3_content` , `text`) VALUES ( NULL ,  'leute',  'filter_link_adv',  'de',  '0',  '0', '<h1>Manuelle Filter-Verknpfung</h1>Fr jeden angewandten Filter erscheint in obiger Liste eine Nummer, ber die der Filter im Textfeld referenziert werden kann.<br />Beispiele:<ul><li><b>0 UND 1:</b> Damit wird der erste Filter ("0") mit einem logischen UND mit dem zweiten ("1") verknpft.</li><li><b>0 UND (1 ODER 2)</b>: Der erste ("0") sowie entweder der zweite oder der dritte Filter ("(1 ODER 2)") mssen zutreffen.</li></ul>');
INSERT INTO  `ko_help` ( `id` , `module` , `type` , `language` , `t3_page` , `t3_content` , `text`) VALUES ( NULL ,  'leute',  'filter_link_adv',  'en',  '0',  '0', '<h1>Manually set filter links</h1>In the list above you can see a number for every currently applied filter. Use these in the input below to add a reference to each filter.<br />Some examples:<ul><li><b>0 AND 1:</b>The first ("0") and second ("1") filter will be linked by a logical AND.</li><li><b>0 AND (1 OR 2)</b>: The first ("0") filter and either the second or third filter ("(1 OR 2)")must match.</li></ul>');

INSERT INTO  `ko_settings` ( `key` , `value`) VALUES ( 'daten_show_mod_to_all',  '0');
INSERT INTO  `ko_settings` ( `key` , `value`) VALUES ( 'res_show_mod_to_all',  '0');
INSERT INTO  `ko_settings` ( `key` , `value`) VALUES ( 'daten_mod_exclude_fields',  '');

ALTER TABLE `ko_admin` ADD `leute_admin_assign` TINYINT NOT NULL AFTER `leute_admin_gs`;
ALTER TABLE `ko_admingroups` ADD `leute_admin_assign` TINYINT NOT NULL AFTER `leute_admin_gs`;

INSERT INTO `ko_settings` (`key`, `value`) VALUES ('leute_assign_global_notification', '');

ALTER TABLE  `ko_groups_datafields` ADD  `private` TINYINT( 2 ) NOT NULL;
ALTER TABLE  `ko_groups_datafields` ADD  `preset` TINYINT( 2 ) NOT NULL;

INSERT INTO `ko_settings` (`key` , `value`) VALUES ('res_attach_ics_for_user', '');

ALTER TABLE `ko_filter` ADD `allow_fastfilter` TINYINT NOT NULL DEFAULT '0';
UPDATE `ko_filter` SET `allow_fastfilter` = '1' WHERE `name` IN ('salutation', 'last name', 'first name', 'address', 'address2', 'zip code', 'city', 'country', 'tel p', 'tel b', 'mobile', 'fax', 'email', 'url', 'civil status', 'sex', 'memo1', 'memo2', 'children', 'family', 'family role', 'firm', 'department', 'sg region', 'sg type', 'sg day', 'smallgrouproles', 'logins', 'id', 'hidden');

ALTER TABLE `ko_log` ADD `session_id` VARCHAR(200) NOT NULL, ADD `request_data` TEXT NOT NULL;

INSERT INTO `ko_settings` (`key` , `value`) VALUES ('res_access_mode', '0');

ALTER TABLE  `ko_event` ADD INDEX  `import_id` (  `import_id` ( 200 ) );

ALTER TABLE  `ko_filter` CHANGE  `name`  `name` VARCHAR( 50 ) NOT NULL DEFAULT  '';

ALTER TABLE  `ko_groups` ADD  `mailing_reply_to` VARCHAR( 20 ) NOT NULL;

ALTER TABLE `ko_donations` ADD `valutadate` DATE NOT NULL AFTER `date`;
ALTER TABLE `ko_donations` ADD INDEX `valutadate` ( `valutadate`);

ALTER TABLE `ko_tracking` ADD `type_multiple` TINYINT(4) NOT NULL DEFAULT '0';
