<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2003-2014 Renzo Lauper (renzo@churchtool.org)
*  All rights reserved
*
*  This script is part of the kOOL project. The kOOL project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*  A copy is found in the textfile GPL.txt and important notices to the license
*  from the author is found in LICENSE.txt distributed with these scripts.
*
*  kOOL is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/

function ko_pdf_daten_start($layout_id) {
	global $ko_path, $pdf;
	global $PDF_sizex, $PDF_sizey, $PDF_rand_rechts, $PDF_rand_links, $PDF_y;

	switch($layout_id) {
		case "1":  //Datenblatt kOOL
			//Constants:
			$PDF_sizex = 210;
			$PDF_sizey = 297;
			$PDF_rand_rechts = 16;
			$PDF_rand_links = 16;
		break;

		case "2":  //Zeitungsinserat kOOL
			//Constants:
			$PDF_sizex = 50;
			$PDF_sizey = 34;
			$PDF_rand_rechts = 1.5;
			$PDF_rand_links = 1.5;
		break;
	}

	define('FPDF_FONTPATH',$ko_path.'fpdf/schriften/');
  require($ko_path.'fpdf/fpdf.php');

	$pdf=new FPDF('P', 'mm', array($PDF_sizex, $PDF_sizey));  //Breite und Hhe in Millimeter
  $pdf->Open();
  $pdf->AddFont('arial','','arial.php');
  $pdf->AddFont('arialb','','arialb.php');
					  
	$pdf->AddPage();

	$PDF_y = 0;

}//ko_pdf_daten_start()



function ko_pdf_daten_end($pdf_filename) {
	global $pdf;

	$pdf->Output($pdf_filename, false);
}//ko_pdf_daten_end()





function ko_pdf_daten_header($id) {
	global $pdf, $ko_path;
	global $PDF_sizex, $PDF_sizey, $PDF_rand_rechts, $PDF_rand_links, $PDF_y;

	switch($id) {


		case "1":  //Datenblatt kOOL
			//Constants:
			$logo_x = $PDF_rand_links;
			$logo_y = $PDF_y+13;
			$logo_width = 75;
			$text_y = $PDF_y+55;
			$line_y = $PDF_y+56;

			//Header
			$header_title = ko_get_pdf_daten_setting("header_title", $id);

			//Logo links oben
		  $pdf->Image($ko_path."fpdf/images/logo.png", $logo_x, $logo_y, $logo_width);

			//Linie
			$pdf->SetDrawColor(0);
			$pdf->SetLineWidth(0.5);
			$pdf->Line($PDF_rand_links, $line_y, ($PDF_sizex - $PDF_rand_rechts), $line_y);

			$pdf->SetFont('arial', '', 13);
			$width = $pdf->GetStringWidth($header_title);
			$pdf->Text( ($PDF_sizex-$width-$PDF_rand_rechts) , $text_y, $header_title);

			$PDF_y = 57;
		break;  //1


		case "2":  //Zeitungsinserat
			//Constants:
			$logo_x = $PDF_rand_links;
			$logo_y = $PDF_y+0.5;
			$logo_width = 28;
			$header_text_1 = "fon 062 823 14 68";
			$header_y_1 = 3;
			$header_text_2 = "www.churchtool.org";
			$header_y_2 = 5.5;

			//Rand ums Ganze rum
			$pdf->SetDrawColor(0);
		  $pdf->SetLineWidth(0.1);
		  $pdf->Rect(0,0, $PDF_sizex, $PDF_sizey);

			//Logo links oben
		  $pdf->Image($ko_path."fpdf/images/logo.png", $logo_x, $logo_y, $logo_width);

			$pdf->SetFont('arial', '', 6);

			//Telefon und Web-Adresse rechts oben
			$h_width = $pdf->GetStringWidth($header_text_1);
	    $h_x = $PDF_sizex - $PDF_rand_rechts - $h_width;
	    $pdf->Text($h_x, $header_y_1, $header_text_1);
			$h_width = $pdf->GetStringWidth($header_text_2);
	    $h_x = $PDF_sizex - $PDF_rand_rechts - $h_width;
	    $pdf->Text($h_x, $header_y_2, $header_text_2);

			$PDF_y = 0;
		break;  //2

	}//switch(id)
}//ko_pdf_daten_header()





function ko_pdf_daten_footer($id) {
	global $pdf, $ko_path;
	global $PDF_sizex, $PDF_sizey, $PDF_rand_rechts, $PDF_rand_links, $PDF_y;

	switch($id) {

		case "1":  //Datenblatt kOOL
			//Constants:
			$text_y = 276;
			$line_y = 272;

			//Linie
			$pdf->SetDrawColor(0);
			$pdf->SetLineWidth(0.5);
			$pdf->Line($PDF_rand_links, $line_y, ($PDF_sizex - $PDF_rand_rechts), $line_y);

			$pdf->SetFont('arial', '', 10);
			$text = "kOOL - the church tool - www.churchtool.org";
			$width = $pdf->GetStringWidth($text);
			$pdf->Text( ($PDF_sizex-$width-$PDF_rand_rechts) , $text_y, $text);
		break;


		case "2":  //Zeitungsinserat Gebetsabend
			//Constants:
			$text1 = "kOOL - the church tool";
			$text2 = "";
			$text_x = 1.5;
			$text_y_1 = 29.5;
			$text_y_2 = 32;

			//Text
			$pdf->SetFont('arial', '', 7);
			$pdf->Text($text_x, $text_y_1, $text1);
			$pdf->Text($text_x, $text_y_2, $text2);
		break;
	}
}//ko_pdf_daten_footer()




function ko_pdf_daten_group($id) {
	global $pdf, $ko_path;
	global $PDF_sizex, $PDF_sizey, $PDF_rand_rechts, $PDF_rand_links, $PDF_y;

	ko_get_pdf_daten_group($group_, $id);
	$group = $group_[$id];
	$layout_id = $group["layout_id"];
	$content = explode(",", $group["content"]);


	switch($layout_id) {

		case "1":
		case "2":
		case "3":
			//Constants
			$pdf_column1 = 25;
			$pdf_column2 = 92;
			$pdf_column3 = 126;
			$font_size_title = 18;
			$font_size_events = 13;
			$font_size_text_small = 10;
			$font_size_text_large = 13;

			//Logo-Teil hinter Titel
			$PDF_y += 3;
			$pdf->Image($ko_path."fpdf/images/pdf-point.png", ($pdf_column1-11), $PDF_y+6, 10);

			//Titel
			$PDF_y += 11;
			$pdf->SetFont('arialb', '', $font_size_title);
			$pdf->Text($pdf_column1, $PDF_y, $group["title"]);

			//Content
			$PDF_y += 2;
			foreach($content as $c) {
				switch($c) {
					case 1:
					case 2:
					case 3:
						if($c == 3) {
							$PDF_y += 6;
							$pdf->SetFont('arialb', '', $font_size_text_large);
						} else {
							$pdf->SetFont('arial', '', $font_size_text_small);
						}
						$text_zeilen = explode("\n", $group["text_".$c]);
						foreach($text_zeilen as $z) {
							$PDF_y += 3;
							$pdf->Text($pdf_column1, $PDF_y, $z);
						}
					break;
					case 5:  //Termine einfgen
						$PDF_y += 6;
						$z_where = "";
						          
						//Termingruppen
						ko_get_eventgruppen($eventgruppen, '', "AND `type` = '0'");
					  if($group["tgs"]) {
		          $tgs = explode(",", $group["tgs"]);
	            $z_where .= " AND (";
	            foreach($tgs as $t) {
	              $z_where .= " e.eventgruppen_id = $t OR";
	            }
							$z_where = substr($z_where,0,-3) . ") ";
	          } else {  //Keine Termingruppen --> FALSE-Bedingung
	            $z_where = " AND 1=2 ";
	          }
											          
						//Exclude
						$exclude_id = $group["exclude"];
	          if($exclude_id) {
							$exclude_ids = explode(",", $exclude_id);
							foreach($exclude_ids as $ei) {
								$z_where .= " AND e.id != $ei";
							}
	          }//if(exclude_id)
											          
						//Datum
						$dates = explode("-", $group["date"]);
	          if($dates[0]) {
	            $tpl_group[$group_counter]["date_selected1"] = $dates[0];
	            $z_where .= " AND ( MONTH(startdatum) >= ".substr($dates[0],0,2)." AND YEAR(startdatum) >= ".substr($dates[0],2).")";
	          }
	          if($dates[1]) {
	            $tpl_group[$group_counter]["date_selected2"] = $dates[1];
	            $z_where .= " AND ( MONTH(enddatum) <= ".substr($dates[1],0,2)." AND YEAR(enddatum) <= ".substr($dates[1],2).")";
	          }
	          ko_get_events($events, $z_where);
						
						$pdf->SetFont('arialb', '', $font_size_events);
	          foreach($events as $e_i => $e) {
							//Datum
	            $termin_string = strftime($GLOBALS["DATETIME"]["DdM"], mktime(1, 1, 1, substr($e["startdatum"],5,2), substr($e["startdatum"],8,2), substr($e["startdatum"],0,4) ) );
	            $pdf->Text($pdf_column1, $PDF_y, $termin_string);
							//Zeit
	            $termin_string = substr($e["startzeit"],0,-3) . " Uhr";
	            $pdf->Text($pdf_column2, $PDF_y, $termin_string);
							//Anlass oder Kommentar
							if($layout_id == 1) {
								$termin_string = $eventgruppen[$e["eventgruppen_id"]]["name"];
							} else if($layout_id == 2) {
								$termin_string = $e["kommentar"];
							} else {
								$termin_string = "";
							}
							$pdf->SetXY($pdf_column3, $PDF_y-4);
              $pdf->MultiCell(0, 5, $termin_string, 0, "L");
              $PDF_y = $pdf->GetY()+4;

							//$pdf->Text($pdf_column3, $PDF_y, $termin_string);
							//$PDF_y += 5;
						}
					break;
				}//switch(c)
			}//foreach(content)

		break; //1,2,3


		
		/**
			* kOOL-Zeitungs-Inserat
			*/
		case "6":  //Gruppen-Layout Zeitung mit Datum
		case "7":  //Gruppen-Layout Zeitung mit Datum und Thema
			//Constants
			$datum_y = 19;
			$titel0x = 1.5;
			$titel0y = 22;
			$titel1x = 1.5;
			$titel1y = 25;

			foreach($content as $c) {
				switch($c) {
					case 1:  //Kommentare
					case 2:
					case 3:
						//TODO:...
					break;

					case 5:  //Termin einfgen
						$z_where = "";
						          
						//Termingruppen
						ko_get_eventgruppen($eventgruppen, '', "AND `type` = '0'");
					  if($group["tgs"]) {
		          $tgs = explode(",", $group["tgs"]);
	            $z_where .= " AND (";
	            foreach($tgs as $t) {
	              $z_where .= " e.eventgruppen_id = $t OR";
	            }
							$z_where = substr($z_where,0,-3) . ") ";
	          } else {  //Keine Termingruppen --> FALSE-Bedingung
	            $z_where = " AND 1=2 ";
	          }
											          
						//Exclude
						$exclude_id = $group["exclude"];
	          if($exclude_id) {
							$exclude_ids = explode(",", $exclude_id);
							foreach($exclude_ids as $ei) {
								$z_where .= " AND e.id != $ei";
							}
	          }//if(exclude_id)
											          
						//Datumsbereich anwenden
						$dates = explode("-", $group["date"]);
	          if($dates[0]) {
	            $tpl_group[$group_counter]["date_selected1"] = $dates[0];
	            $z_where .= " AND ( MONTH(startdatum) >= ".substr($dates[0],0,2)." AND YEAR(startdatum) >= ".substr($dates[0],2).")";
	          }
	          if($dates[1]) {
	            $tpl_group[$group_counter]["date_selected2"] = $dates[1];
	            $z_where .= " AND ( MONTH(enddatum) <= ".substr($dates[1],0,2)." AND YEAR(enddatum) <= ".substr($dates[1],2).")";
	          }
	          ko_get_events($events, $z_where);
						$first = TRUE;
						foreach($events as $e) {
							if($first) {
								$event = $e;
								$first = FALSE;
							}
						}

						//Thema speichern, falls bentigt
						$thema = chr(139)." ".$event["kommentar"]." ".chr(155);

						//Datum ausgeben
            $datum = strftime($GLOBALS["DATETIME"]["DdM"], mktime(1, 1, 1, substr($event["startdatum"],5,2), substr($event["startdatum"],8,2), substr($event["startdatum"],0,4) ) );
						$datum .= " um ".substr($event["startzeit"],0,-3)." Uhr";
						
						$pdf->SetFont('arial', '', 7);
						$pdf->Text($PDF_rand_links, $datum_y, $datum);

						//Titel ausgeben
						$test_fail = TRUE;
						$font_size = 7;
						while($test_fail) {
							$pdf->SetFont('arialb', '', $font_size);
							$test_width = $pdf->GetStringWidth($group["title"]);
							if($test_width > ($PDF_sizex - 2 * $titel0x)) $font_size--;
							else $test_fail = FALSE;
						}
						$pdf->Text($titel0x, $titel0y, $group["title"]);

						//Falls verlangt, Thema ausgeben
						if($layout_id == 7) {  //Thema einfgen

							//Thema bei Doppelpunkt aufsplitten, und auf 2 Zeilen ausgeben
							$thema_a = explode(":", $thema);
							$titel_y_add = 0;
							$t_counter = 1;
							foreach($thema_a as $t) {
								if($t_counter++ < sizeof($thema_a)) $t = $t . ":";  //Doppelpunkt wieder hinzufgen, wenn noch nicht letzte Zeile
								$test_fail = TRUE;
								$font_size = 7;
								while($test_fail) {
									$pdf->SetFont('arial', '', $font_size);
									$test_width = $pdf->GetStringWidth($t);
									if($test_width > ($PDF_sizex - 2 * $titel1x)) $font_size--;
									else $test_fail = FALSE;
								}//while(test_fail)
								$titel_x = (54 - $pdf->GetStringWidth($t)) / 3 * 2;
								$pdf->Text($titel_x, ($titel1y+$titel_y_add), $t);

								$titel_y_add+=2;
							}//foreach(thema_a as t)
						}//if(layout_id == 7)
					break;
				}
			}

		break;
	}//switch(layout_id)


}//ko_pdf_daten_group()
?>
