<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2003-2014 Renzo Lauper (renzo@churchtool.org)
*  All rights reserved
*
*  This script is part of the kOOL project. The kOOL project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*  A copy is found in the textfile GPL.txt and important notices to the license
*  from the author is found in LICENSE.txt distributed with these scripts.
*
*  kOOL is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/

//Set timeout from php.ini if not set manually in ko-config.php
if(!defined('SESSION_TIMEOUT')) {
	define('SESSION_TIMEOUT', ini_get('session.gc_maxlifetime'));
} else {
	session_set_cookie_params(SESSION_TIMEOUT);
}

//Set session save path if set. If not set the system's default path will be used
if(defined('SESSION_SAVE_PATH')) session_save_path(SESSION_SAVE_PATH);

//Set no caching
header("Expires: Thu, 01 Dec 1994 16:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

//Start session
if(FALSE === session_start()) exit;
?>
