<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2003-2014 Renzo Lauper (renzo@churchtool.org)
*  All rights reserved
*
*  This script is part of the kOOL project. The kOOL project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*  A copy is found in the textfile GPL.txt and important notices to the license
*  from the author is found in LICENSE.txt distributed with these scripts.
*
*  kOOL is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/



//quoted_printable_encode() is part of PHP starting with v5.3. So only define if not defined yet.
if(!function_exists('quoted_printable_encode')) {
	function quoted_printable_encode($input, $line_max = 76) {
		$hex = array('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
		$lines = preg_split("/(?:\r\n|\r|\n)/", $input);
		$eol = "\r\n";
		$linebreak = "=0D=0A";
		$escape = "=";
		$output = "";

		for ($j=0;$j<count($lines);$j++) {
			$line = $lines[$j];
			$linlen = strlen($line);
			$newline = "";
			for($i = 0; $i < $linlen; $i++) {
				$c = substr($line, $i, 1);
				$dec = ord($c);
				if ( ($dec == 32) && ($i == ($linlen - 1)) ) { // convert space at eol only
					$c = "=20"; 
				} elseif ( ($dec == 61) || ($dec < 32 ) || ($dec > 126) ) { // always encode "\t", which is *not* required
					$h2 = floor($dec/16); $h1 = floor($dec%16); 
					$c = $escape.$hex["$h2"].$hex["$h1"]; 
				}
				if ( (strlen($newline) + strlen($c)) >= $line_max ) { // CRLF is not counted
					$output .= $newline.$escape.$eol; // soft line break; " =\r\n" is okay
					$newline = "    ";
				}
				$newline .= $c;
			} // end of for
			$output .= $newline;
			if ($j<count($lines)-1) $output .= $linebreak;
		}
		return trim($output);
	}//quoted_printable_encode()
}




if(isset($_GET['id']) && (int)$_GET['id'] > 0) {
	$ko_path = '../../';
	require($ko_path.'inc/ko.inc');

	$id = format_userinput($_GET['id'], 'uint');
	if(!$id) exit;

	if(!ko_module_installed('leute')) exit;
	ko_get_access('leute');
	if($access['leute']['ALL'] < 1 && $access['leute'][$id] < 1) exit;

	$v = new vCard();
	$v->addPerson($id);
	$v->outputCard();
}





class vCard {
	var $properties;
	var $filename;
	var $output;
	var $utf8;


	function vCard($_utf8=FALSE) {
		$this->utf8 = $_utf8;
	}


	function addPerson($person) {
		global $access;

		unset($this->properties);

		if(!ko_module_installed('leute')) exit;
		ko_get_access('leute');

		if(!is_array($person)) {
			$pid = (int)$person;
			if(!$pid) return FALSE;
			ko_get_person_by_id($pid, $person);
			$this->filename = format_userinput($person['vorname'].$person['nachname'], 'js').'.vcf';
		} else {
			$pid = $person['id'];
			$this->filename = 'kOOL_'.date('Ymd_His').'.vcf';
		}
		if($access['leute']['ALL'] < 1 && $access['leute'][$pid] < 1) return FALSE;

		if($person["telp"]) $this->setPhoneNumber($person["telp"], "PREF;HOME;VOICE");
		if($person["telg"]) $this->setPhoneNumber($person["telg"], "PREF;WORK;VOICE");
		if($person["natel"]) $this->setPhoneNumber($person["natel"], "PREF;CELL;VOICE");
		if($person["fax"]) $this->setPhoneNumber($person["fax"], "PREF;FAX");
		if($person["firm"] || $person["department"]) $this->setO(($person["firm"].($person["firm"]?" ":"").$person["department"]));
		$this->setName($person["nachname"], $person["vorname"], "", $person["anrede"]);
		if($person["geburtsdatum"] != "0000-00-00") $this->setBirthday(sql_datum($person["geburtsdatum"]));
		$this->setAddress("", "", $person["adresse"], $person["ort"], "", $person["plz"], $person["land"]);
		if($person["email"]) $this->setEmail($person["email"]);
		//$this->setNote("You can take some notes here.\r\nMultiple lines are supported via \\r\\n.");
		if($person["web"]) $this->setURL($person["web"], "WORK");
		if($person['lastchange'] != '' && $person['lastchange'] != '0000-00-00 00:00:00') $this->setRev($person['lastchange']);

		$this->output .= $this->getVCard();
	}//addPerson()



	function writeCard() {
		global $ko_path;

		$filename = $ko_path.'download/kOOL_'.date('Ymd_His').'.vcf';

		$fp = @fopen($filename, 'w');
		fputs($fp, $this->output);
		fclose($fp);

		return $filename;
	}//writeCard()


	function outputCard() {
		$filename = $this->getFileName();

		header('Cache-Control:');
		header('Content-Disposition: attachment; filename='.$filename);
		header('Content-Length: '.strlen($output));
		header('Connection: close');
		header('Content-Type: text/x-vCard; name='.$filename.'');

		echo $this->output;
	}//outputCard();

	
	function setPhoneNumber($number, $type="") {
	// type may be PREF | WORK | HOME | VOICE | FAX | MSG | CELL | PAGER | BBS | CAR | MODEM | ISDN | VIDEO or any senseful combination, e.g. "PREF;WORK;VOICE"
		$key = "TEL";
		if ($type!="") $key .= ";".$type;
		$key.= ";ENCODING=QUOTED-PRINTABLE";
		$this->properties[$key] = $this->encode($number);
	}
	
	// UNTESTED !!!
	function setPhoto($type, $photo) { // $type = "GIF" | "JPEG"
		$this->properties["PHOTO;TYPE=$type;ENCODING=BASE64"] = base64_encode($photo);
	}
	
	function setFormattedName($name) {
		$this->properties["FN;ENCODING=QUOTED-PRINTABLE"] = $this->encode($name);
	}
	
	function setName($family="", $first="", $additional="", $prefix="", $suffix="") {
		$this->properties['N;ENCODING=QUOTED-PRINTABLE'] = $this->encode($family).';'.$this->encode($first).';'.$this->encode($additional).';'.$this->encode($prefix).';'.$this->encode($suffix);
		if($this->properties['FN;ENCODING=QUOTED-PRINTABLE'] == '') $this->setFormattedName(trim("$prefix $first $additional $family $suffix"));
	}
	
	function setBirthday($date) { // $date format is YYYY-MM-DD
		$this->properties["BDAY"] = $date;
	}
	
	function setAddress($postoffice="", $extended="", $street="", $city="", $region="", $zip="", $country="", $type="HOME;POSTAL") {
	// $type may be DOM | INTL | POSTAL | PARCEL | HOME | WORK or any combination of these: e.g. "WORK;PARCEL;POSTAL"
		$key = "ADR";
		if ($type!="") $key.= ";$type";
		$key.= ";ENCODING=QUOTED-PRINTABLE";
		$this->properties[$key] = $this->encode($name).";".$this->encode($extended).";".$this->encode($street).";".$this->encode($city).";".$this->encode($region).";".$this->encode($zip).";".$this->encode($country);
		
		if ($this->properties["LABEL;$type;ENCODING=QUOTED-PRINTABLE"] == "") {
			//$this->setLabel($postoffice, $extended, $street, $city, $region, $zip, $country, $type);
		}
	}
	
	function setLabel($postoffice="", $extended="", $street="", $city="", $region="", $zip="", $country="", $type="HOME;POSTAL") {
		$label = "";
		if ($postoffice!="") $label.= "$postoffice\r\n";
		if ($extended!="") $label.= "$extended\r\n";
		if ($street!="") $label.= "$street\r\n";
		if ($zip!="") $label.= "$zip ";
		if ($city!="") $label.= "$city\r\n";
		if ($region!="") $label.= "$region\r\n";
		if ($country!="") $country.= "$country\r\n";
		
		$this->properties["LABEL;$type;ENCODING=QUOTED-PRINTABLE"] = $this->encode($label);
	}
	
	function setEmail($address) {
		$this->properties["EMAIL;INTERNET"] = $address;
	}

	function setO($o) {
		$this->properties["O;ENCODING=QUOTED-PRINTABLE"] = $this->encode($o);
	}
	
	function setNote($note) {
		$this->properties["NOTE;ENCODING=QUOTED-PRINTABLE"] = $this->encode($note);
	}
	
	function setURL($url, $type="") {
	// $type may be WORK | HOME
		$key = "URL";
		if ($type!="") $key.= ";$type";
		$this->properties[$key] = $url;
	}

	function setRev($date) {
		$this->properties['REV'] = date_convert_timezone($date, 'UTC');
	}
	
	function getVCard() {
		$text = "BEGIN:VCARD\r\n";
		$text.= "VERSION:2.1\r\n";
		foreach($this->properties as $key => $value) {
			$text.= "$key:".$value."\r\n";
		}
		$text.= "END:VCARD\r\n";
		return $text;
	}
	
	function getFileName() {
		return ($this->filename != '.vcf' && $this->filename != '') ? $this->filename : 'vcard.vcf';
	}



	function encode($string) {
		if($this->utf8) {
			return $this->escape(quoted_printable_encode(utf8_encode($string)));
		} else {
			return $this->escape(quoted_printable_encode($string));
		}
	}//encode()

	function escape($string) {
		return str_replace(";","\;",$string);
	}//escape()


}//class vCard
?>
