<?php if (!defined('InTriggerNote')) exit; ?>
/**********************

	TriggerNote
	(c) Copyright 2015 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

	*** THIS IS NOT FREE SOFTWARE ***

	Unauthorized copying and creating
	derivative code based on parts of this
	code are forbidden by copyright law.
	If you're going to use this script or
	any part of it, please do so legally
	and honestly by buying a copy at:

	http://www.geckotribe.com/TriggerNote/

	Thank you.  Your honesty makes it possible
	for me to take time from other work to
	create and support scripts like this.

**********************/

TriggerNotePluginData=[];

function TriggerNoteList() {
	this.tests=[];
	this.cur=false;
	this.AddTest=function(n,t,isG) {
		if (typeof(this.tests[n])==='undefined') {
			this.cur=this.tests[n]=t;
			if (typeof(isG)!=='undefined') t.grp=isG;
			return 1;
		} else return 0;
	};
	this.RemoveTest=function(n) {
		if (typeof(this.tests[n])!=='undefined') {
			if (this.cur==this.tests[n]) this.cur=false; 
			this.tests[n].DeInit();
			this.tests.splice(n,1);
			return 1;
		} else return 0;
	};
	this.ReplaceTest=function(n,t,isG) {
		this.RemoveTest(n);
		return this.AddTest(n,t,(typeof(isG)!=='undefined')?isG:false);
	};
	this.SelectTest=function(n,tc) {
		var i;
		if (typeof(this.tests[n])!=='undefined') this.cur=this.tests[n];
		else if (typeof(tc)!=='undefined') {
			for (i in this.tests) if ((typeof(this.tests[i].isAGroup)!=='undefined')&&this.tests[i].tests.TryTest(n)) return -1;
			return false;
		}
		return true;
	};
	this.TryTest=function(n) {
		var c=false;
		if ((
			((typeof(n)==='undefined')&&this.cur)
			||((typeof(n)!=='undefined')&&((c=this.SelectTest(n,1))===true))
		)&&this.cur.GetState()) {
			this.cur.Trigger();
			return true;
		} else return (c===-1)?true:false;
	};
	var _self=this;
}

function TriggerNoteTest(args) {
	var _self=this;
	this.state=0;
	this.times=0;
	this.grp=false;
	if (typeof(args)==='undefined') args={};
	var actions=[];
	var aks=[];
	this.NumericArgs=function(l) {
		var i;
		for (i=0;i<l.length;i++) {
			if (typeof(args[l[i]])==='string') args[l[i]]=parseFloat(args[l[i]]);
			if (isNaN(args[l[i]])) args[l[i]]=0;
		}
	};
	this.GetState=function() { return this.state; };
	this.Trigger=function() {
		if (this.times) {
			this.times--;
			aks=[];
			for (var ac in actions) aks.push(ac);
			while (ac=aks.shift()) switch (actions[ac].Do()) {
				case -1: aks=[]; return;
				case 0: return;
			}
		}
		if (this.grp&&this.grp.GetState()) this.grp.Trigger();
		if (!this.times) this.DeInit();
	};
	this.Resume=function() {
		while (ac=aks.shift()) switch (actions[ac].Do()) {
			case -1: aks=[]; return;
			case 0: return;
		}
		if (this.grp&&this.grp.GetState()) this.grp.Trigger();
		if (!this.times) this.DeInit();
	};
	this.BaseReset=function() {
		this.state=0;
		this.times=(typeof(args.times)==='undefined')?-1:args.times;
	};
	this.resetters=[function(){_self.BaseReset();}];
	this.Reset=function() {
		var i;
		for (i=this.resetters.length-1;i>=0;i--) this.resetters[i]();
	};
	this.DeInit=function() {};
	this.AddAction=function(n,a) {
		if (typeof(actions[n])==='undefined') {
			a.trigger=_self;
			actions[n]=a;
			return 1;
		} else return 0;
	};
	this.RemoveAction=function(n) {
		if (typeof(actions[n])!=='undefined') {
			actions.splice(n,1);
			return 1;
		} else return 0;
	};
	this.ReplaceAction=function(n,a) {
		this.RemoveAction(n);
		return this.AddAction(n,a);
	};
	this.Reset();
}

function TriggerNoteAction(args) {
	var trigger;
	var _self=this;
	this.times=0;
	if (typeof(args)==='undefined') args={};
	this.NumericArgs=function(l) {
		var i;
		for (i=0;i<l.length;i++) {
			if (typeof(args[l[i]])==='string') args[l[i]]=parseFloat(args[l[i]]);
			if (isNaN(args[l[i]])) args[l[i]]=0;
		}
	};
	this.BaseReset=function() {
		this.state=0;
		this.times=(typeof(args.times)==='undefined')?-1:args.times;
	};
	this.resetters=[function(){_self.BaseReset();}];
	this.Reset=function() {
		var i;
		for (i=this.resetters.length-1;i>=0;i--) this.resetters[i]();
	};
	this.MoreTimes=function() {
		if (this.times) {
			this.times--;
			return 1;
		} else return 0;
	};
	this.Do=function() { return 1; };
	this.Reset();
}

function TriggerNoteAddEvListener(el,ev,li,cap) {
	if (el.addEventListener) el.addEventListener(ev,li,(typeof(cap)==='undefined')?false:cap);
	else if (el.attachEvent) el.attachEvent('on'+ev,li);
}
function TriggerNoteRemoveEvListener(el,ev,li,cap) {
	if (el.removeEventListener) el.removeEventListener(ev,li,(typeof(cap)==='undefined')?false:cap);
	else if (el.attachEvent) el.attachEvent('on'+ev,li);
}
function TriggerNoteInArray(ar,va) {
	for (var i=ar.length-1;i>-1;i--) if (ar[i]==va) return i+1;
	return 0;
}
