<?php
/**********************

	TriggerNote Common Functions
	(c) Copyright 2015-6 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

**********************/

define('InTriggerNote',1);
require_once dirname(__file__).'/core.php';

global $TriggerNoteSelectorSets,$TriggerNoteTriggerSets,$TriggerNoteTriggerSetsToUse,$TriggerNoteSelectorGroupsToUse;
$TriggerNoteSelectorSets=$TriggerNoteTriggerSets=$TriggerNoteTriggerSetsToUse=$TriggerNoteSelectorGroupsToUse=array();

function TriggerNoteAutoSelect() {
	global $TriggerNote,$TriggerNote_db,$TriggerNoteSelectorSets,$TriggerNoteTriggerSetsToUse,$TriggerNoteSelectorGroupsToUse;
	if (isset($TriggerNote['used-selector-types'])) {
		$dayNum=date('j');
		$monthNum=date('n');
		$yearNum=date('Y');
		$dowNum=1<<date('w');
		$do101=in_array(101,$TriggerNote['used-selector-types']);
		$q=(in_array(100,$TriggerNote['used-selector-types'])?"||(tns_type=100)":'')
			.($do101?"||(tns_type=101)":'')
			.(in_array(40,$TriggerNote['used-selector-types'])?"||((tns_type=40)&&(tns_num&$dowNum))":'')
			.(in_array(41,$TriggerNote['used-selector-types'])?"||((tns_type=41)&&(tns_num<$dayNum))":'')
			.(in_array(42,$TriggerNote['used-selector-types'])?"||((tns_type=42)&&(tns_num>$dayNum))":'')
			.(in_array(43,$TriggerNote['used-selector-types'])?"||((tns_type=43)&&(tns_num<$monthNum))":'')
			.(in_array(44,$TriggerNote['used-selector-types'])?"||((tns_type=44)&&(tns_num>$monthNum))":'')
			.(in_array(45,$TriggerNote['used-selector-types'])?"||((tns_type=45)&&(tns_num<$yearNum))":'')
			.(in_array(46,$TriggerNote['used-selector-types'])?"||((tns_type=46)&&(tns_num>$yearNum))":'')
			.(in_array(47,$TriggerNote['used-selector-types'])?"||((tns_type=47)&&((tns_num<$monthNum)||((tns_num=$monthNum)&&(cast(tns_short as unsigned)<$dayNum))))":'')
			.(in_array(48,$TriggerNote['used-selector-types'])?"||((tns_type=48)&&((tns_num>$monthNum)||((tns_num=$monthNum)&&(cast(tns_short as unsigned)>$dayNum))))":'')
			;

		$q=str_replace('(||','(',$q);
		if (trigger_note_db_q_all("select count(*) as tc,tns_set from `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` where ".substr($q,2)." group by tns_set",$temp)) {
			$counts=$inGroup=array();
			foreach ($temp as &$l) $counts[$l['tns_set']]=$l['tc'];
			if (trigger_note_db_q_all("select count(*) as tc,tns_set from `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` where tns_set in (".implode(',',array_keys($counts)).') group by tns_set',$temp)) {
				$sets=array();
				foreach ($temp as &$l) if ($l['tc']==$counts[$l['tns_set']]) $passedSets[]=$l['tns_set'];
				if (count($passedSets)) {
					if (trigger_note_db_q_all("select `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet`.*".($do101?',tns_type as has101':'')." from `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet`"
						.($do101?" left join `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` on (tns_set=tnss_id)&&(tns_type=101)":'')
						." where tnss_id in (".implode(',',$passedSets).')',$temp)
					) {
						foreach ($temp as &$l) {
							$TriggerNoteSelectorSets[$l['tnss_id']]=json_decode($l['tnss_data'],1);
							if (isset($l['has101']{0})&&!(
								isset($TriggerNoteSelectorSets[$l['tnss_id']]['group'])
								&&isset($TriggerNoteSelectorSets[$l['tnss_id']]['group']{0})
								&&in_array($TriggerNoteSelectorSets[$l['tnss_id']]['group'],$TriggerNoteSelectorGroupsToUse)
							)) unset($TriggerNoteSelectorSets[$l['tnss_id']]);
						}
						$sets=array();
						foreach ($TriggerNoteSelectorSets as $k=>&$one) {
							$key=isset($one['group'])?$one['group']:'';
							if (isset($key{0})) {
								if (!isset($inGroup[$key])) $inGroup[$key]=array();
								$inGroup[$key][]=$k;
								$priority=isset($one['priority'])?$one['priority']:0;
								if ((!isset($sets[$key]))||($priority>$sets[$key][1])) $sets[$key]=array($k,$priority);
							} else foreach ($one['triggers'] as $trig) TriggerNoteUseTriggerSet($trig);
						}
						foreach ($sets as $set) foreach ($TriggerNoteSelectorSets[$set[0]]['triggers'] as $trig) TriggerNoteUseTriggerSet($trig);
					}
				}
			}
		}
	}
}


function TriggerNoteUseTriggerSet($set) {
	global $TriggerNoteTriggerSetsToUse;
	if (!in_array($set,$TriggerNoteTriggerSetsToUse)) $TriggerNoteTriggerSetsToUse[]=$set;
}
function TriggerNoteUseTriggerSets($sets) {
	global $TriggerNoteTriggerSetsToUse;
	foreach ($sets as $set) if (!in_array($set,$TriggerNoteTriggerSetsToUse)) $TriggerNoteTriggerSetsToUse[]=$set;
}

function TriggerNoteUseSelectorGroup($group) {
	global $TriggerNoteSelectorGroupsToUse;
	if (!in_array($group,$TriggerNoteSelectorGroupsToUse)) $TriggerNoteSelectorGroupsToUse[]=$group;
}
function TriggerNoteUseSelectorGroups($groups) {
	global $TriggerNoteSelectorGroupsToUse;
	foreach ($groups as $group) if (!in_array($group,$TriggerNoteSelectorGroupsToUse)) $TriggerNoteSelectorGroupsToUse[]=$group;
}

function TriggerNoteLoadTriggerSets() {
	global $TriggerNote_db,$TriggerNoteTriggerSets,$TriggerNoteTriggerSetsToUse;
	$get=array();
	foreach ($TriggerNoteTriggerSetsToUse as $set) if (!isset($TriggerNoteTriggerSets[$set])) $get[]=$set;
	if (count($get)) if (trigger_note_db_q_all("select * from `{$TriggerNote_db['db_prefix']}TriggerNoteTriggerSet` where tnts_id in (".implode(',',$get).')',$all)) foreach ($all as $one)
		$TriggerNoteTriggerSets[$one['tnts_id']]=json_decode($one['tnts_data'],1);
}

function TriggerNoteHead() {
	global $TriggerNoteTriggerSetsToUse,$trigger_note_path;
	echo '<link rel="stylesheet" type="text/css" href="'.$trigger_note_path.'/style.php?ts='.implode(',',$TriggerNoteTriggerSetsToUse).'"/>';
}

function TriggerNoteBody($tsets=false) {
	global $TriggerNote,$TriggerNoteTriggerSetsToUse,$trigger_note_path;
	if (count($TriggerNoteTriggerSetsToUse)) {
		sort($TriggerNoteTriggerSetsToUse);
		echo '<script type="text/javascript" src="'.$trigger_note_path.'/js.php?ts='.implode(',',$TriggerNoteTriggerSetsToUse).'"/></script>';
		if (isset($TriggerNote['split-test-cookie'])) {
			echo '<script type="text/javascript">';
			foreach ($TriggerNote['split-test-cookie'] as $opt=>&$temp) echo "(function(){t=new Date();t.setTime(t.getTime()+($temp[cookie_duration]*3600000));"
				."document.cookie='$temp[cookie]=$opt;expires='+t.toUTCString()+';path=$temp[cookie_path]';"
				.'})();';
			echo '</script>';
		}
	}
}

return;
?>
