<?php
/**********************

	TriggerNote
	(c) Copyright 2015-6 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

**********************/

define('TriggerNoteAdmin',1);
require_once dirname(__file__).'/../core.php';

$admin=array(
	'triggers'=>array(),
	'actions'=>array(),
	'trigger_recipes'=>array(),
	'action_recipes'=>array(),
	'trigger_select'=>array('Triggers'=>array(),'Recipes'=>array()),
	'action_select'=>array('Actions'=>array(),'Recipes'=>array())
);

function ShowAuthPage($message='',$title='Access Denied') {
	if (defined('SHOWLOGINFORM')) {
		?><!DOCTYPE HTML>
		<html>
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			<title><?php echo $title; ?></title>
		</head>
		<body>
			<h1><?php echo $title; ?></h1>
			<?php if (!empty($message)) echo $message; ?>
			</body>
		</html>
		<?php
	}
	exit;
}

function CheckAllPrivs($u,$p) {
	global $TriggerNote_db;
	return isset($TriggerNote_db['allprivs-user'])&&isset($TriggerNote_db['allprivs-pw'])
		&&($TriggerNote_db['allprivs-user']==$u)&&($TriggerNote_db['allprivs-pw']==$p);
}

function TriggerNoteLoadPlugins() {
	global $admin;
	$rv=0;
	if ($dh=opendir(dirname(__file__).'/actions')) {
		while ($l=readdir($dh)) if ($l{0}!='.') require_once dirname(__file__)."/actions/$l";
		closedir($dh);
		if ($dh=opendir(dirname(__file__).'/triggers')) {
			while ($l=readdir($dh)) if ($l{0}!='.') require_once dirname(__file__)."/triggers/$l";
			closedir($dh);
			if ($dh=opendir(dirname(__file__).'/recipes/trigger')) {
				while ($l=readdir($dh)) if ($l{0}!='.') require_once dirname(__file__)."/recipes/trigger/$l";
				closedir($dh);
				if ($dh=opendir(dirname(__file__).'/recipes/action')) {
					while ($l=readdir($dh)) if ($l{0}!='.') require_once dirname(__file__)."/recipes/action/$l";
					closedir($dh);
					$rv=1;
					foreach ($admin['triggers'] as $k=>$v) $admin['trigger_select']['Triggers'][$k]=$v['name'];
					asort($admin['trigger_select']['Triggers']);
					foreach ($admin['trigger_recipes'] as $k=>$v) $admin['trigger_select']['Recipes']["-$k"]=$v['name'];
					asort($admin['trigger_select']['Recipes']);
					foreach ($admin['actions'] as $k=>$v) $admin['action_select']['Actions'][$k]=$v['name'];
					asort($admin['action_select']['Actions']);
					foreach ($admin['action_recipes'] as $k=>$v) $admin['action_select']['Recipes']["-$k"]=$v['name'];
					asort($admin['action_select']['Recipes']);
				}
			}
		}
	}
	return $rv;
}

global $username;
if (defined('SKIPLOGIN')) $username='';
else {
	if (isset($TriggerNote_db['auth_method'])) $TriggerNote['auth_method']=$TriggerNote_db['auth_method'];
	else if (!isset($TriggerNote['auth_method'])) $TriggerNote['auth_method']='basic';
	switch($TriggerNote['auth_method']) {
	case 'cookie':
		$authed=0;
		if (isset($_POST)&&isset($_POST['u'])&&isset($_POST['u']{0})&&isset($_POST['p'])) {
			$username=stripslashes($_POST['u']);
			$pw=stripslashes($_POST['p']);
			if (isset($TriggerNote['users'][$username])&&($TriggerNote['users'][$username]['p']==md5($pw))) {
				$authed=1;
				SetCookie('TriggerNoteAdmin',"$username-".md5($username.$TriggerNote['users'][$username]['p']),0,
					substr($_SERVER['PHP_SELF'],0,strrpos($_SERVER['PHP_SELF'],'/')+1));
			} else if (CheckAllPrivs($username,$pw)) {
				$authed=1;
				SetCookie('TriggerNoteAdmin',"$username-allprivs",0,substr($_SERVER['PHP_SELF'],0,strrpos($_SERVER['PHP_SELF'],'/')+1));
			}
		} else if (isset($_COOKIE['TriggerNoteAdmin'])) {
			if (($dash=strrpos($_COOKIE['TriggerNoteAdmin'],'-'))!==false) {
				$username=substr($_COOKIE['TriggerNoteAdmin'],0,$dash);
				$hash=substr($_COOKIE['TriggerNoteAdmin'],$dash+1);
				if (
					(isset($TriggerNote['users'][$username])&&($hash==md5($username.$TriggerNote['users'][$username]['p'])))
					||(($hash=='allprivs')&&isset($TriggerNote_db['allprivs-user'])&&($TriggerNote_db['allprivs-user']==$username))
				) $authed=1;
			}
		}
		if (!$authed) {
			ShowAuthPage(
				'Sign in to TriggerNote.<br /><br />'.
				'<form action="'.str_replace('index.php','',$_SERVER['PHP_SELF']).'" method="POST"><table cellpadding="5">'.
				'<tr><td>Username</td><td><input name="u" size="20" /></td></tr>'.
				'<tr><td>Password</td><td><input type="password" name="p" size="20" /></td></tr>'.
				'<tr><td>&nbsp;</td><td><input type="submit" value="Login" /></td></tr>'.
				'</table></form>'
				,'Sign In'
			);
		}
		break;
	case 'basic':
	case 'basic-php':
		if (isset($_SERVER['PHP_AUTH_USER'])&&isset($_SERVER['PHP_AUTH_USER']{0})) {
			$username=$_SERVER['PHP_AUTH_USER'];
			$pw=$_SERVER['PHP_AUTH_PW'];
		} else foreach (array('HTTP_AUTHORIZATION','REDIRECT_REMOTE_USER','REDIRECT_HTTP_AUTHORIZATION','REMOTE_USER') as $temp)
			if (isset($_SERVER[$temp])&&isset($_SERVER[$temp]{0})
		) {
			list($username,$pw)=explode(':',base64_decode(substr($_SERVER[$temp],6)),2);
			break;
		} else $username='';

		if (isset($username{0})) {
			switch($TriggerNote['auth_method']) {
			case 'basic':
				if ((!isset($TriggerNote['users'][$username]))&&!CheckAllPrivs($username,$pw)) $username='';
				break;
			case 'basic-php':
				if (((!isset($TriggerNote['users'][$username]))||(md5($pw)!=$TriggerNote['users'][$username]['p']))&&!CheckAllPrivs($username,$pw)) $username='';
				break;
			}
		}

		if (!isset($username{0})) {
			if ($TriggerNote['auth_method']=='basic-php') {
				header('HTTP/1.0 401 Unauthorized');
				header('WWW-Authenticate: Basic realm="TriggerNote"');
			}
			ShowAuthPage(
				'If entering the correct username and password does not enable you to log in,'
				.' see the sections of the README on what to do if you forgot your password, and using cookie-based login.'
			);
		}
		break;
	default: $username='';
	}
	if (isset($username{0})&&isset($TriggerNote_db['allprivs-user'])&&($TriggerNote_db['allprivs-user']==$username)) $TriggerNote['users'][$username]['a']=1;
}

return;
?>
