<?php
/**********************

	TriggerNote Admin Control Panel JavaScript Code
	(c) Copyright 2015-6 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

**********************/

define('InTriggerNote',1);
require_once dirname(__file__).'/admin-core.php';

if (TriggerNoteLoadPlugins()) {
	echo 'recipes={trigger:[],action:[]};'
		.'TriggerOpts=[["Triggers"';
		foreach ($admin['trigger_select']['Triggers'] as $k=>$v) echo ",['$k','$v']";
	echo '],["Recipes"';
		foreach ($admin['trigger_select']['Recipes'] as $k=>$v) echo ",['$k','$v']";
	echo ']];ActionOpts=[["Actions"';
		foreach ($admin['action_select']['Actions'] as $k=>$v) echo ",['$k','$v']";
	echo '],["Recipes"';
		foreach ($admin['action_select']['Recipes'] as $k=>$v) echo ",['$k','$v']";
	echo ']];TriggerTypes={';
		$comma='';
		foreach ($admin['triggers'] as $k=>$v) {
			echo "$comma'$k':{name:'{$v['name']}'}";
			$comma=',';
		}
	echo '};ActionTypes={';
		$comma='';
		foreach ($admin['actions'] as $k=>$v) {
			echo "$comma'$k':{name:'{$v['name']}'}";
			$comma=',';
		}
	echo '};';
	foreach ($admin['triggers'] as $v) $v['optForm']();
	foreach ($admin['actions'] as $v) $v['optForm']();
	foreach ($admin['trigger_recipes'] as $v) $v['optForm']();
	foreach ($admin['action_recipes'] as $v) $v['optForm']();
}
echo "trigger_note_path='$trigger_note_path';";
?>
function AddSelectOptions(e1,cur,opts,isMulti) {
	var i1,i2,j,e2,e3;
	if (typeof(isMulti)==='undefined') isMulti=0;
	for (i1=0,j=0;i1<opts.length;i1++) {
		if (typeof(opts[i1][1])==='string') {
			e3=document.createElement('option');
			e3.value=opts[i1][0];
			e3.text=opts[i1][1];
			e1.appendChild(e3);
			if (isMulti) {
				if (InArray(cur,opts[i1][0])) e3.selected=true;
			} else if (opts[i1][0]==cur) e1.selectedIndex=j;
			j++;
		} else {
			e2=document.createElement('optgroup');
			e2.label=opts[i1][0];
			e1.appendChild(e2);
			for (i2=1;i2<opts[i1].length;i2++,j++) {
				e3=document.createElement('option');
				e3.value=opts[i1][i2][0];
				e3.text=opts[i1][i2][1];
				e2.appendChild(e3);
				if (isMulti) {
					if (InArray(cur,opts[i1][i2][0])) e3.selected=true;
				} else if (opts[i1][i2][0]==cur) e1.selectedIndex=j;
			}
		}
	}
}

function CreateSelect(id,cur,opts) {
	var e1;
	e1=document.createElement('select');
	e1.id=id;
	e1.setAttribute('name',id);
	AddSelectOptions(e1,cur,opts);
	return e1;
}

function TNAddImgButton(src,cls,act,id) {
	var rv;
	rv=document.createElement('img');
	rv.src=src;
	rv.className=cls;
	MyAddEvListener(rv,'click',act);
	if (typeof(id)!=='undefined') rv.id=id;
	return rv;
}
function TNAddElement(tag,cls,id) {
	var rv;
	rv=document.createElement(tag);
	rv.className=cls;
	if (typeof(id)!=='undefined') rv.id=id;
	return rv;
}
function BuildOptionFormElement(tag,name,id,def,data,val,cur,multi) {
	var el,j;
	el=document.createElement(tag);
	el.name=name;
	el.id=id;
	if ((typeof(val)==='undefined')||(val!==false)) el.value=((typeof(val)!=='undefined')?val:(
			(typeof(data[def.name])!=='undefined')?data[def.name]:(
				(typeof(def.default)!=='undefined')?def.default:''
			)
		)
	);
	if ((typeof(cur)!=='undefined')&&(
		((!multi)&&(val==cur))||(multi&&InArray(cur,val))
	)) el.checked=true;
	if (typeof(def.class)!=='undefined') el.className=def.class;
	if (typeof(def.attributes)!=='undefined') for (j=0;j<def.attributes.length;j++)
		el.setAttribute(def.attributes[j][0],def.attributes[j][1]);
	if (typeof(def.handlers)!=='undefined') for (j=0;j<def.handlers.length;j++)
		(function(i){MyAddEvListener(el,def.handlers[i][0],function(){def.handlers[i][1](el);});})(j);
	return el;
}
function BuildOptionFormRow(baseName,par,def,data,notablelabel) {
	var i,j,re,ce,el,op,cur;
	par.appendChild(re=document.createElement('tr'));
	re.appendChild(ce=document.createElement('td'));
	if (typeof(def[0])==='function') {
		ce.colSpan='2';
		def[0](baseName,data,ce);
	} else {
		if (typeof(notablelabel)==='undefined') ce.className='tablelabel';
		ce.innerHTML=def[0];
		re.appendChild(ce=document.createElement('td'));
		for (i=1;i<def.length;i++) {
			switch(def[i].type) {
			case 'text':
				el=document.createElement((typeof(def[i].tag)==='undefined')?'span':def[i].tag);
				el.innerHTML=def[i].content;
				ce.appendChild(el);
				break;
			case 'input': case 'textarea':
				 el=BuildOptionFormElement(def[i].type,baseName+def[i].name,baseName+def[i].name,def[i],data);
				 ce.appendChild(el);
				 break;
			case 'checkbox': case 'radio':
				cur=(typeof(data[def[i].name])!=='undefined')?data[def[i].name]:((typeof(def[i].default)!=='undefined')?def[i].default:'');
				for (j=0;j<def[i].options.length;j++) {
					el=BuildOptionFormElement('input',baseName+def[i].name+((def[i].type=='checkbox')?'[]':''),baseName+def[i].name+j,def[i],data,def[i].options[j][0],cur,def[i].type=='checkbox');
					el.type=def[i].type;
					ce.appendChild(el);
					el=document.createElement('label');
					el.setAttribute('for',baseName+def[i].name+j);
					el.innerHTML=' '+def[i].options[j][1];
					ce.appendChild(el);
					if (j<(def[i].options-1)) switch(def[i].between) {
					case 'space': el=document.createElement('span'); el.innerHTML=' '; ce.appendChild(el); break;
					case 'break': el=document.createElement('br'); ce.appendChild(el); break;
					}
				}
				break;
			case 'select':
			case 'multi-select':
				el=BuildOptionFormElement('select',baseName+def[i].name+((def[i].type=='multi-select')?'[]':''),baseName+def[i].name,def,'',false);
				ce.appendChild(el);
				cur=(typeof(data[def[i].name])!=='undefined')?data[def[i].name]:((typeof(def[i].default)!=='undefined')?def[i].default:'');
				AddSelectOptions(el,cur,def[i].options,(def[i].type=='multi-select'));
				break;
			}
		}
	}
}
function BuildOptionForm(baseName,par,def,data,skipStd) {
	var r,el;
	el=document.createElement('table');
	el.className='aT';
	par.appendChild(el);
	for (r=0;r<def.length;r++) BuildOptionFormRow(baseName,el,def[r],data);
	if (typeof(skipStd)==='undefined') {
		BuildOptionFormRow(baseName,el,['Maximum Times'
			,{type:'input',name:'times',default:'-1',attributes:[['type','number'],['min','-1'],['max','999']]}
			,{type:'text',content:' -1 = no limit'}
			],data);
	}
	return el;
}
function CloseRecipeBox() { ToggleClass('recipebox','noshow','','add'); }
function ApplyRecipe(type,pari,recipe) {
	var i,j,d,s,v,c,data=JSON.parse(JSON.stringify(recipe.recipe));
	for (i=0;i<recipe.mods.length;i++) {
		for (d=data,j=0;j<(recipe.mods[i].path.length-1);j++) d=d[recipe.mods[i].path[j]];
		s=document.getElementById(recipe.mods[i].src);
		v=((s.type=='select-one')?s.options[s.selectedIndex].value:((s.type=='checkbox')?(s.checked?s.value:''):s.value));
		d[recipe.mods[i].path[j]]=((typeof(recipe.mods[i].process)!=='undefined')?recipe.mods[i].process(v,recipe.mods[i],d[recipe.mods[i].path[j]]):v);
	}
	if (typeof(recipe.styles)!=='undefined') for (i=0;i<recipe.styles.length;i++) {
		if (typeof(recipe.styles[i].src)!=='undefined') {
			s=document.getElementById(recipe.styles[i].src);
			c=((s.type=='select-one')?s.options[s.selectedIndex].value:((s.type=='checkbox')?(s.checked?s.value:''):s.value));
			if (typeof(recipe.styles[i].val)!=='undefined') v=(recipe.styles[i].val==c);
			else if (typeof(recipe.styles[i].process!=='undefined')) v=recipe.styles[i].process(c,recipe.styles[i]);
			else v=-1;
		} else v=1;
		if (v!=-1) for (j=1,s=document.getElementById('stylesheet'+j);s=document.getElementById('stylesheet'+j);j++) if (s.value==recipe.styles[i].ss) {
			s.checked=(v?true:false);
			break;
		}
	}
	if (typeof(recipe.imgs)!=='undefined') for (i=0;i<recipe.imgs.length;i++) {
		for (d=data,j=0;j<(recipe.imgs[i].length-1);j++) d=d[recipe.imgs[i][j]];
		d[recipe.imgs[i][j]]=d[recipe.imgs[i][j]].replace(/\/TriggerNote\/img\//g,trigger_note_path+'/img/');
	}
	if (typeof(recipe.removals)!=='undefined') for (i=0;i<recipe.removals.length;i++) {
		s=document.getElementById(recipe.removals[i].src);
		v=((s.type=='select-one')?s.options[s.selectedIndex].value:((s.type=='checkbox')?(s.checked?s.value:''):s.value));
		if (recipe.removals[i].process(v)) {
			for (d=data,j=0;j<(recipe.removals[i].path.length-1);j++) d=d[recipe.removals[i].path[j]];
			d.splice(recipe.removals[i].path[j],1);
		}
	}
	CloseRecipeBox();
	if (type=='trigger') AddTrigger(pari,data);
	else for (i=0;i<data.length;i++) AddAction(pari,data[i].type,data[i].o);
}
function ShowRecipeUI(type,pari,recipe) {
	var e1,e2;
	e1=document.getElementById('recipeboxform');
	e1.innerHTML='';
	e2=BuildOptionForm('',e1,recipe.ui,[],1);
	BuildOptionFormRow('',e2,['',{type:'input',name:'recipeboxsubmit',default:'Apply Recipe',attributes:[['type','button']]
		,handlers:[['click',function(el){ApplyRecipe(type,pari,recipe);}]]}],[]);
	ToggleClass('recipebox','noshow','','remove');
}
function AddTrigger(pari,data) {
	var ttype,parc,myi,pa,pa1,el,c1,i,j;
	if (typeof(data)==='undefined') {
		data=[];
		el=document.getElementById((pari=='first')?'top-sel':(pari+'-t-sel'));
		ttype=el.options[el.selectedIndex].value;
	} else ttype=data['type'];
	if (ttype.charAt(0)=='-') {
		if (typeof(recipes.trigger[ttype.substr(1)].ui)==='undefined') AddTrigger(pari,recipes.trigger[ttype.substr(1)].recipe);
		else ShowRecipeUI('trigger',pari,recipes.trigger[ttype.substr(1)]);
	} else {
		if (pari=='first') {
			parc='top-cont';
			myi='top';
			ToggleClass('tsform','cansave','','add');
		} else {
			parc=pari+'-t-cn';
			for (i=0;document.getElementById(pari+'-tc-'+i);i++) {}
			myi=pari+'-tc-'+i;
		}
		pa=document.getElementById(parc);
		if (parc!='top-cont') ToggleClass(pa.parentNode,'close','open','fromto');
		pa.appendChild(el=TNAddElement('div','bgt open',myi));
		pa=el;
		el=document.createElement('input');
			el.setAttribute('type','hidden');
			el.name=myi+'-type';
			el.value=ttype;
			pa.appendChild(el);
		pa.appendChild(TNAddImgButton('../img/expanded.png','closebutton',function(){ToggleClass(myi,'open','close','fromto');}));
		pa.appendChild(TNAddImgButton('../img/collapsed.png','openbutton',function(){ToggleClass(myi,'close','open','fromto');}));
		pa.appendChild(TNAddImgButton('../img/delete.png','fR',function(){RemoveTrigger(myi);}));
		el=document.createElement('h1');
			el.innerHTML=TriggerTypes[ttype]['name'];
			pa.appendChild(el);
		el=document.createElement('span');
			el.innerHTML='Unique Trigger ID: ';
			el.className='uid';
			pa.appendChild(el);
		el=document.createElement('input');
			el.size='15';
			el.id=el.name=myi+'-id';
			if (typeof(data['id'])!=='undefined') el.value=data['id'];
			el.className='uid';
			pa.appendChild(el);
		el=document.createElement('span');
			el.innerHTML=' (optional)';
			el.className='uid';
			pa.appendChild(el);
		pa.appendChild(el=TNAddElement('div','tn_container'));
		pa=el;

		pa.appendChild(pa1=TNAddElement('div','bg open',myi+'-opts'));
			pa1.appendChild(TNAddImgButton('../img/expanded.png','closebutton',function(){ToggleClass(myi+'-opts','open','close','fromto');}));
			pa1.appendChild(TNAddImgButton('../img/collapsed.png','openbutton',function(){ToggleClass(myi+'-opts','close','open','fromto');}));
			el=document.createElement('h2');
				el.innerHTML='Options';
				el.className='nof';
				pa1.appendChild(el);
			pa1.appendChild(el=TNAddElement('div','tn_container'));
				BuildOptionForm(myi+'-o-',el,TriggerTypes[ttype].optForm,(typeof(data['o'])!=='undefined')?data['o']:[]);

		pa.appendChild(pa1=TNAddElement('div','bg open',myi+'-actions'));
			pa1.appendChild(TNAddImgButton('../img/expanded.png','closebutton',function(){ToggleClass(myi+'-actions','open','close','fromto');}));
			pa1.appendChild(TNAddImgButton('../img/collapsed.png','openbutton',function(){ToggleClass(myi+'-actions','close','open','fromto');}));
			el=document.createElement('h2');
				el.innerHTML='Actions';
				pa1.appendChild(el);
			pa1.appendChild(CreateSelect(myi+'-a-sel','',ActionOpts));
			pa1.appendChild(el=document.createElement('span'));
				el.innerHTML=' ';
			pa1.appendChild(el=document.createElement('input'));
				el.type='button';
				el.value='Add Action';
				MyAddEvListener(el,'click',function(){AddAction(myi)});

			pa1.appendChild(TNAddElement('div','tn_container',myi+'-a-cn'));

			if (typeof(data['a'])!=='undefined') for (i=0,j=data['a'].length;i<j;i++)
				AddAction(myi,data['a'][i]['type'],data['a'][i]['o'],(typeof(data['a'][i]['id'])!=='undefined')?data['a'][i]['id']:'');
	}
}
function RemoveTrigger(id) {
	var el,pn,idp,i,j,inps;
	if (confirm('Remove this section?')) {
		if (el=document.getElementById(id)) {
			pn=el.parentNode;
			pn.removeChild(el);
			if (id=='top') {
				while (pn.childNodes.length&&((typeof(pn.childNodes[0].tagName)==='undefined')||(pn.childNodes[0].tagName!='DIV'))) pn.removeChild(pn.childNodes[0]);;
				if (!pn.childNodes.length) ToggleClass('tsform','cansave','','remove');
			} else {
				idp=id.split('-');
				if (idp[idp.length-2]=='a') {
					i=parseInt(idp.pop());
					inps=pn.getElementsByTagName('input');
					for (j=inps.length-1;j>=0;j--) if ((inps[j].name.substr(-4)=='-seq')&&(parseInt(inps[j].value)>i)) inps[j].value=parseInt(inps[j].value)-1;
				}
			}
		}
	}
}
function AddAction(pari,atype,options,uid) {
	var i,pa,el,aid;
	if (typeof(options)==='undefined') {
		options=[];
		el=document.getElementById(pari+'-a-sel');
		atype=el.options[el.selectedIndex].value;
	}
	if (atype.charAt(0)=='-') {
		if (typeof(recipes.action[atype.substr(1)].ui)==='undefined')
			for (i=0;i<recipes.action[atype.substr(1)].recipe.length;i++)
				AddAction(pari,recipes.action[atype.substr(1)].recipe[i].type,recipes.action[atype.substr(1)][i].recipe);
		else ShowRecipeUI('action',pari,recipes.action[atype.substr(1)]);
	} else {
		for (i=0;document.getElementById(pari+'-a-'+i+'-seq');i++) {}
		aid=pari+'-a-'+i;
		pa=document.getElementById(pari+'-a-cn');
		ToggleClass(pa.parentNode,'close','open','fromto');

		el=document.createElement('div'); pa.appendChild(el);
		pa=el;
			pa.id=aid;
			pa.className='bg open';
		el=document.createElement('input'); pa.appendChild(el);
			el.setAttribute('type','hidden');
			el.name=el.id=aid+'-seq';
			el.value=i;
		el=document.createElement('input'); pa.appendChild(el);
			el.setAttribute('type','hidden');
			el.name=el.id=aid+'-type';
			el.value=atype;
		pa.appendChild(TNAddImgButton('../img/expanded.png','closebutton',function(){ToggleClass(aid,'open','close','fromto')}));
		pa.appendChild(TNAddImgButton('../img/collapsed.png','openbutton',function(){ToggleClass(aid,'close','open','fromto')}));
		pa.appendChild(TNAddImgButton('../img/moveup.png','flButton',function(){MoveActionUpDown(aid,-1)}));
		pa.appendChild(TNAddImgButton('../img/movedown.png','flButton',function(){MoveActionUpDown(aid,1)}));
		pa.appendChild(TNAddImgButton('../img/delete.png','fR',function(){RemoveTrigger(aid)}));
		el=document.createElement('h3'); pa.appendChild(el);
			el.innerHTML=ActionTypes[atype]['name'];
		el=document.createElement('span');
			el.innerHTML='Unique Action ID: ';
			el.className='uid';
			pa.appendChild(el);
		el=document.createElement('input');
			el.size='15';
			el.id=el.name=aid+'-id';
			if (typeof(uid)!=='undefined') el.value=uid;
			el.className='uid';
			pa.appendChild(el);
		el=document.createElement('span');
			el.innerHTML=' (optional)';
			el.className='uid';
			pa.appendChild(el);
		pa.appendChild(el=TNAddElement('div','tn_container'));
			BuildOptionForm(pari+'-a-'+i+'-o-',el,ActionTypes[atype].optForm,options);
	}
}
function RemoveAction(id) {
	var el;
	if (el=document.getElementById(id+'-cont')) el.parentNode.removeChild(el);
}
function MoveActionUpDown(e1,dir) {
	var e2,s;
	e1=document.getElementById(e1);
	if (dir==1) {
		for (e2=e1;e2.nextSibling;e2=e2.nextSibling)
			if ((typeof(e2.id)!=='undefined')&&(e2.id!=e1.id)) break;
	} else {
		for (e2=e1;e1.previousSibling;e1=e1.previousSibling)
			if ((typeof(e1.id)!=='undefined')&&(e2.id!=e1.id)) break;
		if (typeof(e1.id)==='undefined') e2=e1;
	}
	if ((typeof(e2.id)!=='undefined')&&(e2.id!=e1.id)) {
		e1.parentNode.insertBefore(e2,e1);
		if (s=document.getElementById(e1.id+'-seq')) s.value=parseInt(s.value)+1;
		if (s=document.getElementById(e2.id+'-seq')) s.value=parseInt(s.value)-1;
	}
}



selectorTypes={
100:{name:'Always select',opts:[]}
,101:{name:'Must load group explicitly',opts:[]}

,40:{name:'Day of week',opts:[
		['',{type:'checkbox',name:'dow',options:[[1,'Sun'],[2,'Mon'],[4,'Tue'],[8,'Wed'],[16,'Thu'],[32,'Fri'],[64,'Sat']]}]
	]}
,41:{name:'Day of month greater than',opts:[
		['',{type:'input',name:'tns_num',attributes:[['type','number'],['min','1'],['max','30']]}]
	]}
,42:{name:'Day of month less than',opts:[
		['',{type:'input',name:'tns_num',attributes:[['type','number'],['min','2'],['max','31']]}]
	]}
,43:{name:'Month is after',opts:[
		['',{type:'select',name:'tns_num',default:<?php echo date('m'); ?>
			,options:[[1,'January'],[2,'February'],[3,'March'],[4,'April'],[5,'May'],[6,'June'],[7,'July'],[8,'August'],[9,'September'],[10,'October'],[11,'November'],[12,'December']]}]
	]}
,44:{name:'Month is before',opts:[
		['',{type:'select',name:'tns_num',default:<?php echo date('m'); ?>
			,options:[[1,'January'],[2,'February'],[3,'March'],[4,'April'],[5,'May'],[6,'June'],[7,'July'],[8,'August'],[9,'September'],[10,'October'],[11,'November'],[12,'December']]}]
	]}
,45:{name:'Year greater than',opts:[
		['',{type:'input',name:'tns_num',default:<?php echo date('Y'); ?>,attributes:[['type','number'],['min','2015'],['max','3000']]}]
	]}
,46:{name:'Year less than',opts:[
		['',{type:'input',name:'tns_num',default:<?php echo date('Y'); ?>,attributes:[['type','number'],['min','2015'],['max','3000']]}]
	]}
,47:{name:'Month/day is after',opts:[
		['',{type:'select',name:'tns_num',default:<?php echo date('m'); ?>
			,options:[[1,'January'],[2,'February'],[3,'March'],[4,'April'],[5,'May'],[6,'June'],[7,'July'],[8,'August'],[9,'September'],[10,'October'],[11,'November'],[12,'December']]}
			,{type:'input',name:'tns_short',attributes:[['type','number'],['min','1'],['max','31']]}]
	]}
,48:{name:'Month/day is before',opts:[
		['',{type:'select',name:'tns_num',default:<?php echo date('m'); ?>
			,options:[[1,'January'],[2,'February'],[3,'March'],[4,'April'],[5,'May'],[6,'June'],[7,'July'],[8,'August'],[9,'September'],[10,'October'],[11,'November'],[12,'December']]}
			,{type:'input',name:'tns_short',attributes:[['type','number'],['min','1'],['max','31']]}]
	]}

};

function RemoveSelector(el) {
	if (confirm('Remove this selector?')&&(el=document.getElementById(el))) el.parentNode.removeChild(el);
}

function AddSelector(data) {
	var r,s,e1,e2,e3,def;
	if (typeof(data)==='undefined') {
		e1=document.getElementById('newselector');
		data={tns_type:e1.options[e1.selectedIndex].value};
	}
	for (s=0;document.getElementById('sel'+s);s++) {}
	def=selectorTypes[data.tns_type];
	e1=document.getElementById('selectors');
	e1.appendChild(e2=TNAddElement('div','bg','sel'+s));
	e2.appendChild(TNAddImgButton('../img/delete.png','fR',function(){RemoveSelector('sel'+s)}));
	e2.appendChild(e3=document.createElement('h3'));
		e3.innerHTML=def.name;
	e2.appendChild(e3=document.createElement('input'));
		e3.setAttribute('name','seltype'+s);
		e3.type='hidden';
		e3.value=data.tns_type;
	if (typeof(data.tns_id)!=='undefined') {
		e2.appendChild(e3=document.createElement('input'));
		e3.setAttribute('name','selnum'+s);
		e3.type='hidden';
		e3.value=data.tns_id;
	}
	e2.appendChild(e3=document.createElement('table'));
	for (r=0;r<def.opts.length;r++) BuildOptionFormRow('sel'+s,e3,def.opts[r],data,0);
}
function AddSelectors() {
	var i;
	for (i=0;i<selectors.length;i++) AddSelector(selectors[i]);
}




function E2Element(e) {
	return (typeof(e)==='string')?document.getElementById(e):(
		(typeof(e)==='undefined')?window.event.srcElement:(
			((typeof(e.target)!=='undefined')&&(typeof(e.href)==='undefined'))?e.target:(
				(typeof(e.srcElement)!=='undefined')?e.srcElement:e
	)));
}
function MyAddEvListener(theEl,theEv,theList) {
	if (theEl.addEventListener) theEl.addEventListener(theEv,theList,false);
	else if (theEl.attachEvent) theEl.attachEvent('on'+theEv,theList);
}
function MyRemoveEvListener(theEl,theEv,theList) {
	if (theEl.removeEventListener) theEl.removeEventListener(theEv,theList,false);
	else if (theEl.attachEvent) theEl.attachEvent('on'+theEv,theList);
}
function InArray(ar,va) {
	for (var i=ar.length-1;i>-1;i--) if (ar[i]==va) return i+1;
	return 0;
}
function ToggleClass(el,c1,c2,op) {
	var cns,i;
	if (el=E2Element(el)) {
		if (typeof(c2)==='undefined') c2='';
		if (typeof(op)==='undefined') op='toggle';
		if (op=='tover') el.className=((el.className==c1)?'':c1);
		else {
			cns=el.className.split(' ');
			switch(op) {
			case 'add': if (!InArray(cns,c1)) cns[cns.length]=c1; break;
			case 'remove': if (i=InArray(cns,c1)) cns[i-1]=''; break;
			case 'toggle':
				if (i=InArray(cns,c1)) cns[i-1]=c2;
				else if (c2.length&&(i=InArray(cns,c2))) cns[i-1]=c1;
				else cns[cns.length]=c1;
				break;
			case 'fromto':
				if (i=InArray(cns,c1)) cns[i-1]='';
				if (!InArray(cns,c2)) cns[cns.length]=c2;
				break;
			}
			el.className=cns.join(' ').replace(/  +/,' ');
		}
	}
	return false;
}
