<?php
/**********************

	TriggerNote Admin Control Panel
	(c) Copyright 2015-8 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

**********************/

define('InTriggerNote',1);
define('SHOWLOGINFORM',1);
require_once dirname(__file__).'/admin-core.php';

$or='';
function ShowFeatureLink($l,$p) {
	global $or,$TriggerNote,$username;
	if ($TriggerNote['users'][$username]['a']&$p) {
		echo "$or$l";
		$or=' | ';
	}
}
?>
<!DOCTYPE html>
<html>
<head>
	<title>TriggerNote Control Panel</title>
	<link rel="stylesheet" type="text/css" href="admin.css"/>
	<script type="text/javascript" src="admin-js.php"></script>
	<link rel="shortcut icon" href="../img/triggernote-32.png"/>
</head>
<body>
<div id="main"><div class="section">

<table><tr>
	<td><img src="../img/triggernote.png"/></td>
	<td>
		<h1>TriggerNote Lite v<?php echo $TriggerNote_version; ?> Control Panel</h1>
		<div style="margin:12px 0 0 5px;"><?php
			ShowFeatureLink('<a href="controlpanel.php?c=list-sets">Trigger Sets</a>',7);
			ShowFeatureLink('<a href="controlpanel.php?c=list-selectors">Selectors</a>',11);
			ShowFeatureLink('<a href="controlpanel.php?c=list-users">Users</a>',3);
		?></div>
	</td>
</tr></table>

<?php
function SaveSettings() {
	global $TriggerNote,$TriggerNote_db;
	$rv=0;
	if (trigger_note_db_x("insert into `{$TriggerNote_db['db_prefix']}TriggerNote_conf` set conf='".addslashes(json_encode($TriggerNote))."'")) {
		$rv=1;
		if (($olds=trigger_note_db_q("select count(*) as tc from `{$TriggerNote_db['db_prefix']}TriggerNote_conf`",'tc'))>1)
			if (!trigger_note_db_x("delete from `{$TriggerNote_db['db_prefix']}TriggerNote_conf` order by cid limit ".($olds-1))) {
				trigger_note_db_error('<p>Database error clearing old configuration.</p>');
				$rv=0;
			}
	} else trigger_note_db_error('<p>Database error saving settings.</p>');
	return $rv;
}
function ReturnSelect($id,$cur,$onChg,$opts) {
	$rv='';
	foreach ($opts as $k=>$v) if (is_array($v)) {
		$rv.='<optgroup label="'.$k.'">';
		foreach ($v as $gk=>$gv) $rv.='<option value="'.$gk.'"'.(($gk==$cur)?' selected':'').">$gv</option>";
		$rv.='</optgroup>';
	} else $rv.='<option value="'.$k.'"'.(($k==$cur)?' selected':'').">$v</option>";
	return '<select name="'.$id.'" id="'.$id.'"'
		.(isset($onChg{0})?(' onChange="'.$onChg.'"'):'')
		.'>'.$rv."</select>\n";
}

function DrawStyleCheckboxes($path,&$selected) {
	global $ss_num;
	$styles=$dirs=array();
 	if ($dh=opendir($base=(dirname(__file__)."/../style/$path"))) {
		while ($fn=readdir($dh)) if ($fn{0}!='.') {
			if (is_dir("$base/$fn")) $dirs[]=$fn;
			else $styles[]=$fn;
		}
		sort($styles);
		sort($dirs);
		closedir($dh);
		foreach ($styles as $one) {
			echo '<div class="style_opt"><input type="checkbox" name="stylesheet'.$ss_num.'" id="stylesheet'.$ss_num.'"'
				.' value="'.htmlspecialchars("$path/$one").'"'.(in_array("$path/$one",$selected)?' checked':'').'>'
				.'<label for="stylesheet'.$ss_num.'"> '.htmlspecialchars($one).'</label></div>';
			$ss_num++;
		}
		foreach ($dirs as $one) {
			echo '<h3>'.htmlspecialchars($one).'</h3><div class="style_dir">';
			DrawStyleCheckboxes("$path/$one",$selected);
			echo '</div>';
		}
	}
}

function ListTriggerSets() {
	global $TriggerNote_db;
	echo '<h2>Trigger Sets</h2><p><a href="controlpanel.php?c=add-set">Add Trigger Set</a></p>';
	if (trigger_note_db_q_all("select tnts_id,tnts_name from `{$TriggerNote_db['db_prefix']}TriggerNoteTriggerSet` order by tnts_name",$all)) {
		if (count($all)) {
			?>
			<table class="aT roomy roundtable">
			<tr class="tablehead">
				<td>#</td>
				<td>Name</td>
				<td colspan="3"></td>
			</tr>
			<?php
			foreach ($all as $one) echo '<tr><td>'.$one['tnts_id'].'</td>'
				.'<td><a href="controlpanel.php?c=edit-set&amp;id='.$one['tnts_id'].'">'.htmlspecialchars($one['tnts_name']).'</a></td>'
				.'<td><a href="controlpanel.php?c=json-set&amp;id='.$one['tnts_id'].'" title="JSON"><img src="../img/code.png"/></a></td>'
				.'<td><a href="controlpanel.php?c=clone-set&amp;id='.$one['tnts_id'].'" title="Duplicate"><img src="../img/duplicate.png"/></a></td>'
				.'<td><a href="controlpanel.php?c=cfmdelete-set&amp;id='.$one['tnts_id'].'" title="Delete"><img src="../img/delete.png"/></a></td>'
				."</tr>\n";
			echo '</table>';
		} else echo '<p>No Trigger Sets found.</p>';
	} else trigger_note_db_error('<p>Database error loading Trigger Set list.</p>');
}

function ListSelectors() {
	global $TriggerNote_db;
	echo '<h2>Selectors</h2><p><a href="controlpanel.php?c=add-selector">Add Selector</a></p>';
	if (trigger_note_db_q_all("select tnss_id,tnss_name from `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet` order by tnss_name",$all)) {
		if (count($all)) {
			?>
			<table class="aT roomy roundtable">
			<tr class="tablehead">
				<td>#</td>
				<td>Name</td>
				<td colspan="2"></td>
			</tr>
			<?php
			foreach ($all as $one) echo '<tr><td>'.$one['tnss_id'].'</td>'
				.'<td><a href="controlpanel.php?c=edit-selector&amp;id='.$one['tnss_id'].'">'.htmlspecialchars($one['tnss_name']).'</a></td>'
				.'<td><a href="controlpanel.php?c=clone-selector&amp;id='.$one['tnss_id'].'" title="Duplicate"><img src="../img/duplicate.png"/></a></td>'
				.'<td><a href="controlpanel.php?c=cfmdelete-selector&amp;id='.$one['tnss_id'].'" title="Delete"><img src="../img/delete.png"/></a></td>'
				."</tr>\n";
			echo '</table>';
		} else echo '<p>No Selectors found.</p>';
	} else trigger_note_db_error('<p>Database error loading Selector list.</p>');
}


function ListUsers() {
	global $TriggerNote,$username;
	?>
	<h2>Users</h2>

	<form action="controlpanel.php" method="POST"><p>
	<input type="hidden" name="c" value="main-conf"/>
	Password protection method:
	<select name="auth_method">
		<option value="basic"<?php if ((!isset($TriggerNote['auth_method']))||($TriggerNote['auth_method']=='basic')) echo ' selected'; ?>>External "Basic"</option>
		<option value="basic-php"<?php if ($TriggerNote['auth_method']=='basic-php') echo ' selected'; ?>>Internal "Basic"</option>
		<option value="cookie"<?php if ($TriggerNote['auth_method']=='cookie') echo ' selected'; ?>>Cookies</option>
	</select>
	<input type="submit" value="Save"/>
	</p></form>

	<p><a href="controlpanel.php?c=add-user">Add User</a></p>
	<?php
	if (count($TriggerNote['users'])) {
		?>
		<table class="aT roomy roundtable">
		<tr class="tablehead">
			<td>Username</td>
			<td></td>
		</tr>
		<?php
		foreach ($TriggerNote['users'] as $k=>$one) echo '<tr><td><a href="controlpanel.php?c=edit-user&amp;id='.$k.'">'.htmlspecialchars($k).'</a></td>'
			.'<td>'.(($k==$username)?'':('<a href="controlpanel.php?c=cfmdelete-user&amp;id='.$k.'" title="Delete"><img src="../img/delete.png"/></a>')).'</td>'
			."</tr>\n";
		echo '</table>';
	} else echo '<p>No users found.</p>';
}



$c=isset($_REQUEST['c'])?$_REQUEST['c']:'list-sets';

switch($c) {
// Trigger Sets
case 'list-sets':
	if ($TriggerNote['users'][$username]['a']&7) ListTriggerSets();
	else echo '<p>Access denied.</p>';
	break;
case 'json-set':
	if ($TriggerNote['users'][$username]['a']&7) {
		if (isset($_GET['id'])&&($id=floor($_GET['id']))) {
			if (is_array($data=trigger_note_db_q("select * from `{$TriggerNote_db['db_prefix']}TriggerNoteTriggerSet` where tnts_id=$id")))
				echo '<h2>JSON Code for Trigger Set "'.htmlspecialchars($data['tnts_name']).'"</h2>'
					.'<p>(Copy the following code if you wish to create your own recipe based on these settings.)</p>'
					.'<p>'.htmlspecialchars($data['tnts_data']).'</p>';
			else trigger_note_db_error('<p>Database error loading Trigger Set, or Trigger Set not found.</p>');
		} else echo '<p>Trigger Set ID not specified.</p>';
		ListTriggerSets();
	} else echo '<p>Access denied.</p>';
	break;
case 'update-set':
	if ($TriggerNote['users'][$username]['a']&7) {
		if (isset($_POST['id'])&&($id=floor($_POST['id']))) {
			$verb='update';
			$where=" where tnts_id=$id";
		} else echo '<p>Trigger Set ID not specified.</p>';
		if (!$id) break;
	}
	// fall through
case 'save-set':
	if ($TriggerNote['users'][$username]['a']&7) {
		if ($c=='save-set') {
			$id=0;
			$verb='insert into';
			$where='';
		}
		$q='';
		$data=$stylesheets=array();
		$usedtypes=array('trigger'=>array(),'action'=>array());
		$ignore=array('c','id','name');
		foreach ($_POST as $k=>$v) if (substr($k,0,10)=='stylesheet') $stylesheets[]=stripslashes($v);
		else if ((!in_array($k,$ignore))&&(substr($k,-4)!='-sel')) {
			$p=explode('-',$k);
			if (($p[count($p)-1]=='type')&&(
				(count($p)==2)
				||(
					preg_match('/^[0-9]+$/',$p[count($p)-2])&&(
						($p[count($p)-3]=='a')||($p[count($p)-3]=='tc')
					)
				)
			)) if (!in_array($v,$usedtypes[((count($p)==2)||($p[count($p)-3]=='tc'))?'trigger':'action']))
				$usedtypes[((count($p)==2)||($p[count($p)-3]=='tc'))?'trigger':'action'][]=$v;
			if ($p[0]=='top') {
				$d=&$data;
				for ($i=1,$j=count($p)-1;$i<$j;$i++) {
					if (!isset($d[$p[$i]])) $d[$p[$i]]=array();
					if ($p[$i]=='o') $d=&$d['o'];
					else {
						if (!isset($d[$p[$i]][$p[$i+1]])) $d[$p[$i]][$p[$i+1]]=array();
						$d=&$d[$p[$i]][$p[$i+1]];
						$i++;
					}
				}
				if (is_array($v)) {
					foreach ($v as $vk=>$vv) $v[$vk]=stripslashes($vv);
					$d[$p[$j]]=$v;
				} else $d[$p[$j]]=stripslashes($v);
			}
		}
		function CleanActionListSort($a,$b) {
			return ($a['seq']>$b['seq'])?1:(($a['seq']<$b['seq'])?-1:0);
		}
		function CleanActionLists(&$data) {
			foreach (array_keys($data) as $k) if (is_array($data[$k])) {
				if ($k==='a') {
					$t=array_keys($data[$k]);
					if (count($t)&&isset($data[$k][$t[0]]['seq'])) {
						usort($data[$k],CleanActionListSort);
						foreach ($data[$k] as &$a) unset($a['seq']);
					} else CleanActionLists($data[$k]);
				} else CleanActionLists($data[$k]);
			}
		}
		CleanActionLists($data);
		function CleanTriggerLists(&$data) {
			foreach (array_keys($data) as $k) if (is_array($data[$k])) {
				if ($k==='tc') sort($data[$k]);
				else CleanTriggerLists($data[$k]);
			}
		}
		CleanTriggerLists($data);
		echo (trigger_note_db_x("$verb `{$TriggerNote_db['db_prefix']}TriggerNoteTriggerSet` set tnts_name='{$_POST['name']}',tnts_updated=".time()
			.",tnts_plugins='".addslashes(json_encode($usedtypes))."'"
			.",tnts_style='".addslashes(json_encode($stylesheets))."'"
			.",tnts_data='".addslashes(json_encode($data))."' $where")
		)?'<p>Trigger set saved.</p>':trigger_note_db_error('<p>Database error saving trigger set.</p>',0);
		if (!isset($_POST['keep-editing'])) ListTriggerSets();
		else if ($c=='save-set') $_REQUEST['id']=trigger_note_db_insert_id();
	} else echo '<p>Access denied.</p>';
	if (!isset($_POST['keep-editing'])) break;
	// fall through
case 'edit-set':
case 'clone-set':
	if ($TriggerNote['users'][$username]['a']&7) {
		if (isset($_REQUEST['id'])&&($id=floor($_REQUEST['id']))) {
			if (is_array($data=trigger_note_db_q("select * from `{$TriggerNote_db['db_prefix']}TriggerNoteTriggerSet` where tnts_id=$id"))) {
				$data['tnts_style']=($data['tnts_style']&&isset($data['tnts_style']{0}))?json_decode($data['tnts_style'],1):array();
				if ($c=='clone-set') {
					$id=0;
					$data['tnts_name']='';
				}
			} else trigger_note_db_error('<p>Database error loading Trigger Set, or Trigger Set not found.</p>');
		} else echo '<p>Trigger Set ID not specified.</p>';
		if (!is_array($data)) break;
	}
	// fall through
case 'add-set':
	if ($TriggerNote['users'][$username]['a']&7) {
		if ($c=='add-set') {
			$id=0;
			$data=array('tnts_name'=>'','tnts_style'=>array());
		}
		if (TriggerNoteLoadPlugins()) {
			echo '<form action="controlpanel.php" method="POST" id="tsform"'.(isset($data['tnts_data'])?' class="cansave"':'').'>'
				.'<b>Trigger Set Name</b>: <input name="name" value="'.htmlspecialchars($data['tnts_name']).'" size="30"/>'
				.' <input name="keep-editing" id="savecontinuebutton" type="submit" value="Save and Keep Editing"/> <input id="savebutton" type="submit" value="Save and Finish"/>'
				.((($c=='edit-set')||($c=='save-set')||($c=='update-set'))
					?('<input type="hidden" name="c" value="update-set"/><input type="hidden" name="id" value="'.$id.'"/>')
					:('<input type="hidden" name="c" value="save-set"/>')
				).'<div id="top-s">'.ReturnSelect('top-sel','','',$admin['trigger_select'])
				.' <input type="button" onClick="AddTrigger(\'first\')" value="Select"/></div>'
				.'<div id="style_opts" class="close">'
				.'<img src="../img/expanded.png" class="closebutton" onClick="'."ToggleClass('style_opts','open','close','fromto')".'"/>'
				.'<img src="../img/collapsed.png" class="openbutton" onClick="'."ToggleClass('style_opts','close','open','fromto')".'"/>'
				.'<h2>Extra Stylesheets</h2>'
				.'<div class="tn_container bg" style="max-height:220px;overflow:auto;">';
			$ss_num=1;
			DrawStyleCheckboxes('',$data['tnts_style']);
			echo '</div></div>'
				.'<div id="top-cont"></div></form>'
				.'<div id="recipebox" class="noshow"><img id="closerecipebox" src="../img/x-32-blue.png" onClick="CloseRecipeBox()"/><div id="recipeboxform"></div></div>';
			if (isset($data['tnts_data'])) echo '<script type="text/javascript">triggerSet='.$data['tnts_data'].';'
				.'MyAddEvListener(window,"load",function(){AddTrigger("first",triggerSet)});</script>';
		} else echo '<p>Failed to load plugin code.</p>';
	} else echo '<p>Access denied.</p>';
	break;
case 'cfmdelete-set':
	if ($TriggerNote['users'][$username]['a']&7) {
		if (isset($_GET['id'])&&($id=floor($_GET['id']))) {
			if (is_array($data=trigger_note_db_q("select tnts_name from `{$TriggerNote_db['db_prefix']}TriggerNoteTriggerSet` where tnts_id=$id"))) {
				?>
				<form action="controlpanel.php" method="POST">
				<input type="hidden" name="c" value="delete-set"/>
				<input type="hidden" name="id" value="<?php echo $id; ?>"/>
				<h2>Delete Trigger Set</h2>
				<p>Are you sure you want to delete the Trigger Set "<?php echo htmlspecialchars($data['tnts_name']); ?>"?</p>
				<p><input type="submit" value="Yes, Delete It"/></p>
				</form>
				<?php
			} else trigger_note_db_error('<p>Database error loading Trigger Set, or Trigger Set not found.</p>');
		} else echo '<p>Trigger Set ID not specified.</p>';
	} else echo '<p>Access denied.</p>';
	break;
case 'delete-set':
	if ($TriggerNote['users'][$username]['a']&7) {
		if (isset($_POST['id'])&&($id=floor($_POST['id']))) {
			if (trigger_note_db_x("delete from `{$TriggerNote_db['db_prefix']}TriggerNoteTriggerSet` where tnts_id=$id")) {
				echo '<p>Trigger Set deleted.</p>';
				if (trigger_note_db_q_all("select * from `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet`",$all)) {
					foreach ($all as $one) {
						$temp=json_decode($one['tnss_data'],1);
						if ($i=array_search($id,$temp['triggers'])) {
							array_splice($temp['triggers'],$i,1);
							if (!trigger_note_db_x("update `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet`"
								." set tnss_data='".addslashes(json_encode($temp))."' where tnss_id=$one[tnss_id]")
							) trigger_note_db_error('<p>Database error updating Selector Sets.</p>');
						}
					}

				} else trigger_note_db_error('<p>Database error checking Selector Sets.</p>');
			} else trigger_note_db_error('<p>Database error deleting Trigger Set.</p>');
		} else echo '<p>Trigger Set ID not specified.</p>';
		ListTriggerSets();
	} else echo '<p>Access denied.</p>';
	break;






// Selectors
case 'list-selectors':
	if ($TriggerNote['users'][$username]['a']&11) ListSelectors();
	else echo '<p>Access denied.</p>';
	break;
case 'edit-selector':
case 'clone-selector':
	if ($TriggerNote['users'][$username]['a']&11) {
		$go=0;
		if (isset($_GET['id'])&&($id=floor($_GET['id']))) {
			if (is_array($data=trigger_note_db_q("select * from `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet` where tnss_id=$id"))) {
				$data['tnss_data']=json_decode($data['tnss_data'],1);
				if (trigger_note_db_q_all("select * from `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` where tns_set=$id",$selectors)) {
					$go=1;
					if ($c=='clone-selector') {
						$id=0;
						$data['tnss_name']='';
					}
					foreach ($selectors as $k=>&$v) {
						switch($v['tns_type']) {
						case 40:
							$temp=$v['tns_num'];
							$v['dow']=array();
							for ($i=1;$i<128;$i*=2) if ($temp&$i) $v['dow'][]=$i;
							break;
						}
					}
				} else trigger_note_db_error('<p>Database error loading Selector details.</p>');
			} else trigger_note_db_error('<p>Database error loading Selector, or Selector not found.</p>');
		} else echo '<p>Selector ID not specified.</p>';
		if (!$go) break;
	}
	// fall through
case 'add-selector':
	if ($TriggerNote['users'][$username]['a']&11) {
		if ($c=='add-selector') {
			$id=0;
			$data=array('tnss_name'=>'','tnss_data'=>array('group'=>'','priority'=>'','triggers'=>array()));
			$selectors=array();
		}
		if (trigger_note_db_q_all("select tnts_id,tnts_name from `{$TriggerNote_db['db_prefix']}TriggerNoteTriggerSet` order by tnts_name",$triggersets)) {
			echo '<form action="controlpanel.php" method="POST">'
				.(($c=='edit-selector')
					?('<input type="hidden" name="c" value="update-selector"/><input type="hidden" name="id" value="'.$id.'"/>')
					:('<input type="hidden" name="c" value="save-selector"/>')
				);
			?>
			<table class="aT">
			<tr>
				<td class="tablelabel">Selector Set Name</td>
				<td><input name="name" size="20" maxlength="60" value="<?php echo htmlspecialchars($data['tnss_name']); ?>"/></td>
			</tr><tr>
				<td class="tablelabel">Selector Group</td>
				<td><input name="group" size="10" value="<?php echo htmlspecialchars($data['tnss_data']['group']); ?>"/> (optional)</td>
			</tr><tr>
				<td class="tablelabel">Group Priority</td>
				<td><input name="priority" type="number" min="0" max="999" value="<?php echo htmlspecialchars($data['tnss_data']['priority']); ?>"/> (optional)</td>
			</tr><tr>
				<td class="tablelabel">Selectors</td>
				<td>
					<select name="newselector" id="newselector">
						<option value=""></option>
						<option value="100">Always select</option>
						<option value="101">Must load group explicitly</option>
						<optgroup label="Date">
							<option value="40">Day of week</option>
							<option value="41">Day of month greater than</option>
							<option value="42">Day of month less than</option>
							<option value="43">Month is after</option>
							<option value="44">Month is before</option>
							<option value="47">Month/day is after</option>
							<option value="48">Month/day is before</option>
							<option value="45">Year greater than</option>
							<option value="46">Year less than</option>
						</optgroup>
					</select>
					<input type="button" value="Add Selector" onClick="AddSelector()"/>
					<div id="selectors" class="aT"></div>
				</td>
			</tr><tr>
				<td class="tablelabel">Trigger Sets</td>
				<td><div style="max-height:200px;overflow:auto;background-color:#e3e3e3;padding:2px 2px 2px 8px;"><?php
					foreach ($triggersets as $one)
						echo '<input type="checkbox" name="ts'.$one['tnts_id'].'" id="ts'.$one['tnts_id'].'" value="'.$one['tnts_id'].'"'.(in_array($one['tnts_id'],$data['tnss_data']['triggers'])?' checked':'').'/>'
							.'<label for="ts'.$one['tnts_id'].'"> '.htmlspecialchars($one['tnts_name']).'</label><br/>';
				?></div></td>
			</tr><tr>
				<td class="tablelabel"></td>
				<td><input type="submit" value="Save Selector Set"/></td>
			</tr>
			</table>
			</form>
			<?php
			if (($c=='edit-selector')||($c=='clone-selector')) echo '<script type="text/javascript">selectors='.json_encode($selectors).';'
				.'MyAddEvListener(window,"load",function(){AddSelectors()});</script>';
		} else trigger_note_db_error('<p>Database error loading trigger sets.</p>');
	} else echo '<p>Access denied.</p>';
	break;
case 'update-selector':
	if ($TriggerNote['users'][$username]['a']&11) {
		if (isset($_POST['id'])&&($id=floor($_POST['id']))) {
			$verb='update';
			$where=" where tnss_id=$id";
		} else echo '<p>Selector ID not specified.</p>';
		if (!$id) break;
	}
	// fall through
case 'save-selector':
	if ($TriggerNote['users'][$username]['a']&11) {
		if ($c=='save-selector') {
			$id=0;
			$verb='insert into';
			$where='';
		}
		$data=array('triggers'=>array());
		if (isset($_POST['group'])&&isset($_POST['group']{0})) $data['group']=trim(stripslashes($_POST['group']));
		if (isset($_POST['priority'])&&isset($_POST['priority']{0})) $data['priority']=floor($_POST['priority']);
		foreach ($_POST as $k=>$v) if (preg_match('/^ts[0-9]+$/',$k)&&isset($v{0})) $data['triggers'][]=floor($v);
		if (trigger_note_db_x("$verb `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet` set tnss_name='{$_POST['name']}',tnss_data='".addslashes(json_encode($data))."' $where")) {
			echo '<p>Selector set updated.</p>';
			if ($c=='save-selector') {
				$id=mysql_insert_id();
				$oldsels=array();
			} else if (!trigger_note_db_q_all("select tns_id from `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` where tns_set=$id",$oldsels,'tns_id')) {
				trigger_note_db_error('<p>Database error loading old selector IDs.</p>');
				break;
			}
			foreach ($_POST as $k=>$v) if (preg_match('/^seltype([0-9]+)$/',$k,$m)) {
				$full=isset($_POST["sel{$m[1]}tns_full"])?$_POST["sel{$m[1]}tns_full"]:'';
				$short=isset($full{0})?md5(stripslashes($full)):'';
				$num=isset($_POST["sel{$m[1]}tns_num"])?floor($_POST["sel{$m[1]}tns_num"]):0;
				$selid=isset($_POST["selnum{$m[1]}"])?floor($_POST["selnum{$m[1]}"]):0;
				switch($v) {
				case 40:
					$num=0;
					foreach ($_POST["sel{$m[1]}dow"] as $dow) $num+=$dow;
					break;
				case 47: case 48: $short=floor($_POST["sel{$m[1]}tns_short"]); break;
				}
				if ($selid&&in_array($selid,$oldsels)) {
					if (trigger_note_db_x("update `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` set tns_short='".addslashes($short)."',tns_full='".addslashes($full)."',tns_num='".$num."' where tns_id=$selid"))
						array_splice($oldsels,array_search($selid,$oldsels),1);
					else trigger_note_db_error("<p>Database error updating selector #$selid.</p>");
				} else if (!trigger_note_db_x("insert into `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` set tns_set=$id,tns_type='$v',tns_short='".addslashes($short)."',tns_full='".addslashes($full)."',tns_num='".$num."'"))
					trigger_note_db_error('<p>Database error adding selector.</p>');
			}
			if (count($oldsels)&&!trigger_note_db_x("delete from `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` where tns_id in (".implode(',',$oldsels).')'))
				trigger_note_db_error('<p>Database error deleting deleted selectors.</p>');
			if (trigger_note_db_q_all("select distinct tns_type from `{$TriggerNote_db['db_prefix']}TriggerNoteSelector`",$alltypes,'tns_type')) {
				$TriggerNote['used-selector-types']=$alltypes;
				if (!SaveSettings()) echo '<p>Database error saving selector performance optimization.</p>';
			} else trigger_note_db_error('<p>Database error attempting to optimize selector performance.</p>');
		} else trigger_note_db_error('<p>Database error saving Selector Set.</p>');
		ListSelectors();
	} else echo '<p>Access denied.</p>';
	break;
case 'cfmdelete-selector':
	if ($TriggerNote['users'][$username]['a']&11) {
		if (isset($_GET['id'])&&($id=floor($_GET['id']))) {
			if (is_array($data=trigger_note_db_q("select tnss_name from `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet` where tnss_id=$id"))) {
				?>
				<form action="controlpanel.php" method="POST">
				<input type="hidden" name="c" value="delete-selector"/>
				<input type="hidden" name="id" value="<?php echo $id; ?>"/>
				<h2>Delete Selector</h2>
				<p>Are you sure you want to delete the Selector "<?php echo htmlspecialchars($data['tnss_name']); ?>"?</p>
				<p><input type="submit" value="Yes, Delete It"/></p>
				</form>
				<?php
			} else trigger_note_db_error('<p>Database error loading Selector, or Selector not found.</p>');
		} else echo '<p>Selector ID not specified.</p>';
	} else echo '<p>Access denied.</p>';
	break;
case 'delete-selector':
	if ($TriggerNote['users'][$username]['a']&11) {
		if (isset($_POST['id'])&&($id=floor($_POST['id']))) {
			if (trigger_note_db_x("delete from `{$TriggerNote_db['db_prefix']}TriggerNoteSelector` where tns_set=$id")
				&&trigger_note_db_x("delete from `{$TriggerNote_db['db_prefix']}TriggerNoteSelectorSet` where tnss_id=$id")
			) {
				echo '<p>Selector deleted.</p>';
			} else trigger_note_db_error('<p>Database error deleting Selector.</p>');
		} else echo '<p>Selector ID not specified.</p>';
		ListSelectors();
	} else echo '<p>Access denied.</p>';
	break;












// Main Configuration
case 'main-conf':
	if ($TriggerNote['users'][$username]['a']&1) {
		if (isset($_POST['auth_method'])) {
			$TriggerNote['auth_method']=$_POST['auth_method'];
			if (SaveSettings()) echo '<p>Configuration Updated.</p>';
		}
		ListUsers();
	} else echo '<p>Access denied.</p>';
	break;






// Users
case 'list-users':
	if ($TriggerNote['users'][$username]['a']&3) ListUsers();
	else echo '<p>Access denied.</p>';
	break;
case 'edit-user':
	$user=false;
	if ($TriggerNote['users'][$username]['a']&3) {
		if (isset($_GET['id'])&&isset($_GET['id']{0})) {
			$id=stripslashes($_GET['id']);
			if (isset($TriggerNote['users'][$id])) {
				$user=&$TriggerNote['users'][$id];
				$cn='update-user';
				$label='Update';
				$pwprompt='Change Password';
			} else trigger_note_db_error('<p>User not found.</p>');
		} else echo '<p>User ID not specified.</p>';
	} else echo '<p>Access denied.</p>';
	if ($user===false) break;
	// fall through
case 'add-user':
	if ($TriggerNote['users'][$username]['a']&3) {
		if ($c=='add-user') {
			$id='';
			$user=array('a'=>28);
			$cn='save-user';
			$label='Add';
			$pwprompt='Password';
		}
		?>
		<form action="controlpanel.php" method="POST">
		<input type="hidden" name="c" value="<?php echo $cn; ?>"/>
		<?php if ($c=='edit-user') echo '<input type="hidden" name="id" value="'.$id.'"/>'; ?>
		<h2><?php echo $label; ?> User</h2>
		<table class="aT">
		<tr>
			<td class="tablelabel">Username</td>
			<td><input name="username" size="20" value="<?php echo htmlspecialchars($id); ?>"/></td>
		</tr>
		<?php if ($TriggerNote['auth_method']!='basic') { ?>
			<tr>
				<td class="tablelabel"><?php echo $pwprompt; ?></td>
				<td><input name="pw" type="password" size="20"/></td>
			</tr>
		<?php } ?>
		<tr>
			<td class="tablelabel">Privileges*</td>
			<td>
				<?php if ($TriggerNote['users'][$username]['a']&1) { ?>
					<input type="checkbox" name="a1" id="a1" value="1"<?php if ($user['a']&1) echo ' checked'; ?>/><label for="a1"> Superuser</label><br/>
					<input type="checkbox" name="a2" id="a2" value="1"<?php if ($user['a']&2) echo ' checked'; ?>/><label for="a2"> Edit Users</label><br/>
				<?php } else { ?>
					<img src="../img/<?php echo ($user['a']&1)?'green-check':'red-x'; ?>-20.png"/> Superuser<br/>
					<img src="../img/<?php echo ($user['a']&2)?'green-check':'red-x'; ?>-20.png"/> Edit Users<br/>
				<?php } ?>
				<input type="checkbox" name="a4" id="a4" value="1"<?php if ($user['a']&4) echo ' checked'; ?>/><label for="a4"> Edit Trigger Sets</label><br/>
				<input type="checkbox" name="a8" id="a8" value="1"<?php if ($user['a']&8) echo ' checked'; ?>/><label for="a8"> Edit Selectors</label><br/>
			</td>
		</tr><tr>
			<td class="tablelabel"></td>
			<td><input type="submit" value="<?php echo $label; ?> User"/></td>
		</tr>
		</table>
		</form>
		<ul>
		<li>Anyone with superuser or edit users privileges automatically receives all lower privileges.</li>
		<li>Only superusers can grant superuser or edit users privileges to others.</li>
		</ul>
		<?php
	} else echo '<p>Access denied.</p>';
	break;
case 'update-user':
	$id='';
	if ($TriggerNote['users'][$username]['a']&3) {
		if (isset($_POST['id'])&&isset($_POST['id']{0})) {
			$old=stripslashes($_POST['id']);
			if (isset($TriggerNote['users'][$old])) {
				$id=isset($_POST['username'])?stripslashes($_POST['username']):'';
				if (isset($id{0})) {
					if ($old==$username) define('PREAUTHORIZED',$TriggerNote['users'][$username]['a']);
					if ($id!=$old) {
						if ($old==$username) $username=$id;
						$TriggerNote['users'][$id]=$TriggerNote['users'][$old];
						unset($TriggerNote['users'][$old]);
						$old=$id;
					}
					$user=&$TriggerNote['users'][$old];
					$user['a']&=($TriggerNote['users'][$username]['a']&1)?0:3;
				} else echo '<p>Username not specified.</p>';
			} else echo '<p>User not found.</p>';
		} else echo '<p>User ID not specified.</p>';
	} else echo '<p>Access denied.</p>';
	if (!isset($id{0})) break;
	// fall through
case 'save-user':
	if (($TriggerNote['users'][$username]['a']&3)||defined('PREAUTHORIZED')) {
		if ($c=='save-user') {
			$id=isset($_POST['username'])?stripslashes($_POST['username']):'';
			if (isset($id{0})) $TriggerNote['users'][$id]=array('a'=>0);
			else {
				echo '<p>Username not specified.</p>';
				break;
			}
		}
		$user=&$TriggerNote['users'][$id];
		if (isset($_POST['pw'])&&strlen(trim($_POST['pw']))) $user['p']=md5(stripslashes($_POST['pw']));
		if (defined('PREAUTHORIZED')&&(PREAUTHORIZED&1)) $TriggerNote['users'][$username]['a']=1;
		for ($i=($TriggerNote['users'][$username]['a']&1)?1:4;$i<32;$i*=2)
			if (isset($_POST["a$i"])&&isset($_POST["a$i"]{0})) $TriggerNote['users'][$id]['a']|=$i;
		if (defined('PREAUTHORIZED')&&(PREAUTHORIZED&1)&&!(isset($_POST["a1"])&&isset($_POST["a1"]{0}))) $TriggerNote['users'][$id]['a']--;
		if (SaveSettings()) echo '<p>User settings saved.</p>';
		ListUsers();
	} else echo '<p>Access denied.</p>';
	break;
case 'cfmdelete-user':
	if ($TriggerNote['users'][$username]['a']&3) {
		if (isset($_GET['id'])&&isset($_GET['id']{0})) {
			$id=stripslashes($_GET['id']);
			if (isset($TriggerNote['users'][$id])) {
				?>
				<form action="controlpanel.php" method="POST">
				<input type="hidden" name="c" value="delete-user"/>
				<input type="hidden" name="id" value="<?php echo $id; ?>"/>
				<h2>Delete User</h2>
				<p>Are you sure you want to delete the User "<?php echo htmlspecialchars($id); ?>"?</p>
				<p><input type="submit" value="Yes, Delete It"/></p>
				</form>
				<?php
			} else trigger_note_db_error('<p>User not found.</p>');
		} else echo '<p>User ID not specified.</p>';
	} else echo '<p>Access denied.</p>';
	break;
case 'delete-user':
	if ($TriggerNote['users'][$username]['a']&3) {
		if (isset($_POST['id'])&&isset($_POST['id']{0})) {
			$id=stripslashes($_POST['id']);
			if (isset($TriggerNote['users'][$id])) {
				unset($TriggerNote['users'][$id]);
				if (SaveSettings()) echo '<p>User deleted.</p>';
			} else echo '<p>User not found.</p>';
		} else echo '<p>User ID not specified.</p>';
		ListUsers();
	} else echo '<p>Access denied.</p>';
	break;








}
?>

</div></div>
</body>
</html>
