<?php
/*
TriggerNote Installer
Copyright (c) 2015-6 Gecko Tribe, LLC
All rights reserved
http://www.geckotribe.com/TriggerNote/
*/

$phase=isset($_REQUEST['phase'])?floor($_REQUEST['phase']):0;
$myTables=array(

	'TriggerNote_conf'=>'cid bigint PRIMARY KEY AUTO_INCREMENT,
conf mediumtext'

	,'TriggerNoteTriggerSet'=>'tnts_id int primary key auto_increment,
tnts_name varchar(60),
tnts_updated bigint,
tnts_plugins text,
tnts_style text,
tnts_data mediumtext'

	,'TriggerNoteSelector'=>'tns_id int primary key auto_increment,
tns_set int not null,
index(tns_set),
tns_type tinyint not null,
index(tns_type),
tns_short varchar(32) not null,
index(tns_short),
tns_full varchar(500),
tns_num bigint not null,
index(tns_num)'

	,'TriggerNoteSelectorSet'=>'tnss_id int primary key auto_increment,
tnss_name varchar(60),
tnss_data mediumtext'

	,'TriggerNoteSplitTest'=>'tnst_id int primary key auto_increment,
tnst_name varchar(60),
tnst_selector_group varchar(30) not null,
index(tnst_selector_group),
tnst_priority int,
tnst_data text'

	,'TriggerNoteAnalytics'=>'tna_key varchar(30) not null,
index(tna_key),
tna_refreshed bigint,
tna_start_date date,
tna_end_date date,
tna_data text'
);
$tableCount=count($myTables);

if (isset($_SERVER['PHP_AUTH_USER'])&&isset($_SERVER['PHP_AUTH_USER']{0})) {
	$un=$_SERVER['PHP_AUTH_USER'];
	$pw=$_SERVER['PHP_AUTH_PW'];
} else foreach (array('HTTP_AUTHORIZATION','REDIRECT_REMOTE_USER','REDIRECT_HTTP_AUTHORIZATION','REMOTE_USER') as $temp)
	if (isset($_SERVER[$temp])&&isset($_SERVER[$temp]{0})
) {
	list($un,$pw)=explode(':',base64_decode(substr($_SERVER[$temp],6)),2);
	break;
} else $un='';

switch($phase) {
case 0:
	SetCookie('TriggerNoteInstallTest','1');
	break;
case 1:
	$auth_methods=array();
	if ($_POST['auth_method']=='basic') {
		if (isset($un{0})) $auth_methods[]=array('basic','External "Basic"');
	} else {
		if (isset($un{0})) {
			switch ($_POST['auth_method']) {
			case 'test': $auth_methods[]=array('basic-php','Internal "Basic" (recommended)'); break;
			case 'test-ext': $auth_methods[]=array('basic','External "Basic"'); break;
			}
		} else if ($_POST['auth_method']=='test') {
			header('HTTP/1.0 401 Unauthorized');
			header('WWW-Authenticate: Basic realm="TriggerNote Installer"');
		}
		if (isset($_COOKIE['TriggerNoteInstallTest'])&&($_COOKIE['TriggerNoteInstallTest']=='1')) $auth_methods[]=array('cookie','Cookies');
	}
	
	if (!count($auth_methods)) $phase=-1;
	break;
}

define('installing',1);
define('SKIPLOGIN',1);
require_once dirname(__file__).'/../core.php';
require_once dirname(__file__).'/../default-conf.php';
?>
<!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>Install TriggerNote</title>
	<style type="text/css">
	body { background-color:#fff; }
	body, td, input {
		font-family:Arial,Helvetica,sans serif;
		font-size:11pt;
	}
	h1, #content {
		position:relative;
		left:50%;
		margin-left:-350px;
		width:700px;
	}
	h1 {
		background-color:#03c;
		color:#fff;
		font-size:25pt;
		letter-spacing:-2px;
		padding:5px 15px;
		margin-bottom:0;
	}
	#content { padding:12px 0; }
	table { border-spacing:0; }
	td { padding:3px 5px; }
	.tablehead {
		font-weight:bold;
		color:#fff;
		background-color:#03c;
	}
	.tablelabel {
		font-weight:bold;
		background-color:ddd;
	}
	sup { font-size:8pt; }
	li b { color:#900; }
	</style>
</head>
<body>

<h1>Install TriggerNote</h1>

<div id="content">

<?php
switch($phase) {
case -1:
	?>
	<h2>Authetication Test Failed</h2>
	
	<p>None of the password protection methods we tested worked.
	Please back up and select a different option.</p>
	<?php
case 0:
	?>
	<h2>Before Beginning:</h2>
	
	<ul>
	<li><b>Have a MySQL database ready to store data in.</b></li>
	</ul>
	
	<h2>Test Password Protection Support</h2>

	<form action="install.php" method="post">
	<input type="hidden" name="phase" value="1" />
	
	<?php if (isset($un{0})) { ?>
		<p>I see you have already password protected TriggerNote.
		You may:</p>
		
		<table>
		<tr>
			<td valign="top"><input type="radio" name="auth_method" value="basic" checked /></td>
			<td>Use the password protection you have already set up.</td>
		</tr><tr>
			<td valign="top"><input type="radio" name="auth_method" value="test-ext"/></td>
			<td>Test whether cookies will work too.</td>
		</tr><tr>
			<td valign="top"><input type="radio" name="auth_method" value="test" disabled="true" /></td>
			<td>
				Turn off external password protection, restart your web browser, and reload this page.
				You will then see an option for testing TriggerNote's internal "Basic" password protection.
			</td>
		</tr>
		</table>
	<?php } else { ?>
		<p>TriggerNote supports three password protection methods:</p>
		
		<ol>
		<li>"Basic" authentication handled by TriggerNote</li>
		<li>"Basic" authentication handled externally (for example, using cPanel or .htaccess files)</li>
		<li>Cookies</li>
		</ol>
		
		<p>If your web server supports the first option, it is the easiest to set up, and is compatible with all web browsers.</p>
		
		<p>If you want to use external password protection and have <b>not</b> already set it up,
			please do so now and reload this page before continuing.</p> 

		<p>If you <b>have</b> already set up external password protection, please reload this page.
		If you still see this message after reloading, then the external method will not work on your server.
		In that case, please turn off external password protection and click "Continue &raquo;" to test other methods.</p>
		
		
		<p>When you click "Continue &raquo;", you will be asked for a username and password.
			Enter any username and password you wish.
			If you are asked for a password more than once, click "cancel" to continue.</p>
		
		<input type="hidden" name="auth_method" value="test"/>
	<?php } ?>
		 
	<p><input type="submit" value="Continue &raquo;" /></p>
	</form>
	
	<?php
	break;
case 1:
	?>
	<script type="text/javascript">
	function UpdateAuthMethod(el) {
		var ob,di;
		di=(el.options[el.selectedIndex].value=='basic');
		if (ob=document.getElementById('p1')) ob.disabled=di;
		if (ob=document.getElementById('p2')) ob.disabled=di;
	}
	</script>
	<form action="install.php" method="post">
	<table>
	<tr class="tablehead"><td colspan="2">Password Protection</td></tr>
	<tr>
		<td class="tablelabel">Method</td>
		<td><select name="auth_method" onChange="return UpdateAuthMethod(this)"><?php
			foreach ($auth_methods as $m) echo '<option value="'.$m[0].'">'.$m[1]."</option>\n";
		?></select></td>
	</tr>
	<tr>
		<td class="tablelabel">Username</td>
		<td><input name="un" id="un" size="15" value="<?php echo htmlspecialchars($un); ?>"></td>
	</tr>
	<?php if ($_POST['auth_method']!='basic') { ?>
		<tr>
			<td class="tablelabel">Password</td>
			<td><input type="password" name="p1" id="p1" size="15"<?php if ($auth_methods[0][0]=='basic') echo ' disabled="true"'; ?>></td>
		</tr><tr>
			<td class="tablelabel">Repeat Password</td>
			<td><input type="password" name="p2" id="p2" size="15"<?php if ($auth_methods[0][0]=='basic') echo ' disabled="true"'; ?>></td>
		</tr>
	<?php } ?>
	<tr class="tablehead"><td colspan="2">MySQL Settings</td></tr>
	<tr>
		<td class="tablelabel">Database name</td>
		<td><input name="db_name" size="15" /></td>
	</tr><tr>
		<td class="tablelabel">Username</td>
		<td><input name="db_user" size="15" /></td>
	</tr><tr>
		<td class="tablelabel">Password</td>
		<td><input type="password" name="db_pass" size="15" /></td>
	</tr><tr>
		<td class="tablelabel">Table name prefix</td>
		<td><input name="db_prefix" size="15" /> (usually empty <sup>*1</sup>)</td>
	</tr><tr>
		<td class="tablelabel">Host</td>
		<td><input name="db_host" size="15" value="localhost" /> (usually "localhost")</td>
	</tr><tr>
		<td class="tablelabel">Port</td>
		<td><input name="db_port" size="5" /> (usually empty)</td>
	</tr>

	<tr class="tablehead">
		<td>&nbsp;</td>
		<td><input type="submit" value="Continue &raquo;" /></td>
	</tr>
	</table>
	
	<p>NOTES:</p>
	
	<ol>
	<li>TriggerNote uses <?php echo $tableCount; ?> database tables: <?php echo implode(', ',array_keys($myTables)); ?>.
		If your database already contains tables with any of those names, enter a prefix (for example "tn_")
			which will be added to the beginning of each of TriggerNote's table names.</li>
	</ol>
	
	<input type="hidden" name="phase" value="2" />
	</form>
	<?php
	break;
case 2:
	$textfields=array('db_name','db_host','db_user','db_pass','auth_method');
	$emptytextfields=array('db_prefix');
	$emptynumfields=array('db_port');

	$rq=array();
	$missing=$pwmiss=0;
	foreach ($textfields as $f) if (!strlen($rq[$f]=isset($_REQUEST[$f])?stripslashes($_REQUEST[$f]):'')) $missing=1;
	foreach ($emptytextfields as $f) $rq[$f]=isset($_REQUEST[$f])?stripslashes($_REQUEST[$f]):'';
	foreach ($emptynumfields as $f) if (!($rq[$f]=isset($_REQUEST[$f])?floor($_REQUEST[$f]):0)) $rq[f]='';
	
	switch($_REQUEST['auth_method']) {
	case 'basic':
		$rq['un']=isset($_REQUEST['un'])?stripslashes($_REQUEST['un']):'';
		break;
	default:
		if (!strlen($rq['un']=isset($_REQUEST['un'])?stripslashes($_REQUEST['un']):'')) $missing=1;
		if (isset($_REQUEST['p1'])&&isset($_REQUEST['p1']{0})&&isset($_REQUEST['p2'])) {
			if ($_REQUEST['p1']==$_REQUEST['p2']) $rq['p']=md5(stripslashes($_REQUEST['p1']));
			else $pwmiss=1;
		} else $missing=1;
	}
	
	if ($pwmiss) echo '<p>The passwords you entered did not match. Please back up and try again.</p>';
	else if ($missing) echo '<p>Some required fields were left empty, or "0" (zero) was entered where it is not allowed. Please back up and try again.</p>';
	else {
		if (trigger_note_db_connect($rq['db_host'].(isset($rq['db_port']{0})?":$rq[db_port]":''),$rq['db_user'],$rq['db_pass'],$rq['db_name'])) {
			$continue=1;
			if ($continue) switch(CheckForTables($rq['db_prefix'])) {
			case 0:
				echo '<p>Creating TriggerNote tables...';
				if (CreateTables($rq['db_prefix'])) {
					echo 'done.</p>';
					foreach(array_keys($TriggerNote) as $k) if (isset($rq[$k])) $TriggerNote[$k]=$rq[$k];
					if (isset($rq['un'])) $TriggerNote['users'][$rq['un']]=array('p'=>isset($rq['p'])?$rq['p']:''
						,'a'=>1
						);
					trigger_note_db_x("insert into `$rq[db_prefix]TriggerNote_conf` set conf='".addslashes(json_encode($TriggerNote))."'");
				} else {
					echo 'failed.</p>';
					break;
				}
				// fall through
			case $tableCount:
				?>
				<p>To complete your TriggerNote installation:</p>
				
				<ol>
				<li>Copy the green text below
						and save it in a text file named "myconf.php" in the TriggerNote folder on your webserver:
					
					<div style="font-weight:bold;color:#060;margin-top:10px;">
					&lt;?php return; ?&gt;<br />
					<?php
					foreach ($TriggerNote_db as $k=>$dv) if (isset($rq[$k])&&($rq[$k]!=$dv))
						echo htmlspecialchars("$k=$rq[$k]")."<br />\n";
					?>
					</div></li>
				<li><a target="_blank" href="../myconf.php">Click here</a> to load myconf.php in your web browser
						(opens in a new window)
						and verify that none of your settings are displayed (you should see a blank page).
					If they are, your file was not saved correctly as a PHP file --
						try again using a plain text editor like Notepad.</li>
				<li><a href="controlpanel.php">Click here</a> to go to the TriggerNote control panel.</li>
				</ol>
				<?php
				break;
			default:
				echo '<p>ERROR: Some of the database tables already exist, but not all. This may be caused by a previous TriggerNote installation. If it\'s a previous TriggerNote installation, please use the upgrade script instead of the installation script. Otherwise, back up and choose a different table prefix.</p>';
				break;
			}
		} else echo '<p>ERROR: Failed to connect to MySQL or to the database you named. Please check your username and password.'
			.' Also note that this installer creates tables in your database, but will not create the database -- you must have a database created before running this script.</p>';
	}
	break;
}

function CheckForTables($db_prefix) {
	global $myTables,$tableCount;
	$rv=0;
	foreach (array_keys($myTables) as $table) if (trigger_note_db_x("select count(*) from `$db_prefix$table`")) $rv++;
	if ($rv==$tableCount) echo "<p>NOTE: The database tables already exist. If you don't wish to use the existing tables, please back up and change the table prefix.</p>";
	return $rv;
}

function CreateTables($db_prefix) {
	global $myTables;
	foreach ($myTables as $k=>$v) if (!trigger_note_db_x('create table `'.$db_prefix.$k.'` ('.$v.');')) return false;
	return true;
}
?>

</div>

</body>
</html>
