<?php
/*
TriggerNote URL Loader
Copyright (c) 2010-16 Gecko Tribe, LLC
All rights reserved
http://www.geckotribe.com/TriggerNote/
*/

function TriggerNoteParseURL($u,&$r) {
	$r=parse_url($u);
	$r['scheme']=(strtolower($r['scheme'])=='https')?'ssl://':'';
	if (empty($r['port'])) $r['port']=(empty($r['scheme'])?80:443);
	if ((!isset($r['path']))||!isset($r['path']{0})) $r['path']='/';
	if (!isset($r['query'])) $r['query']='';
	else if (!empty($r['query'])) $r['path'].="?$r[query]";
}

function LoadRemote($method,$scheme,$domain,$port,$path,$args,$headers_in,&$code,&$headers,&$body,$canRedir=0,$redirecting=0) {
	global $LoadRemoteLoopCheck;
	if (!isset($domain{0})) return 1;
	if (!$redirecting) $LoadRemoteLoopCheck=array();
	$rv=0;
	$body='';
	$headers=array();
	$port=empty($port)?(empty($scheme)?80:443):$port;
	$makeURL="$scheme$domain:$port$path".(isset($args{0})?"?$args":'');
	if ((!in_array($makeURL,$LoadRemoteLoopCheck))&&($fp=fsockopen($scheme.$domain,$port,$errno,$errstr,15))) {
		$LoadRemoteLoopCheck[]=$makeURL;
		$common="Host: $domain\r\nConnection: close\r\n";
		if (isset($headers_in{0})) $headers_in=trim($headers_in)."\r\n";
		if ($method!='POST') fputs($fp,"$method $path".(isset($args{0})?"?$args":'')." HTTP/1.0\r\n$common$headers_in\r\n");
		else {
			$ctype=preg_match('/content-type/i',$headers_in)?'':"Content-Type: application/x-www-form-urlencoded\r\n";
			fputs($fp,"POST $path HTTP/1.0\r\n$common$headers_in"."Content-Length: ".strlen($args)."\r\n$ctype\r\n$args");
		}
		$gotHeaders=0;
		$firstLine=1;
		while (!feof($fp)) if (($l=fgets($fp,1000))===false) {
			sleep(1);
		} else {
			if ($gotHeaders) $body.=$l;
			else if (preg_replace("/[\r\n]/",'',$l)==='') {
				$gotHeaders=1;
				if ($canRedir&&isset($headers['location'])) {
					fclose($fp);
					$fp=false;
					if (!preg_match('#^https?://#i',$headers['location']))
						$headers['location']='http'.(isset($scheme{0})?'s':'')."://$domain:$port".$headers['location'];
					TriggerNoteParseURL($headers['location'],$newURL);
					$rv=LoadRemote(($code==303)?'GET':$method,$newURL['scheme'],$newURL['host'],$newURL['port'],$newURL['path'],($code==303)?'':$args,'',$code,$headers,$body,1,1);
					break;	
				}
			} else if ($firstLine) {
				$firstLine=0;
				list($junk,$code)=explode(' ',trim($l));
			} else {
				list($n,$v)=explode(':',$l,2);
				$n=strtolower(trim($n));
				if (isset($headers[$n])) {
					if (!is_array($headers[$n])) $headers[$n]=array($headers[$n]);
					$headers[$n][]=trim($v);
				} else $headers[$n]=trim($v);	
			}
		}
		if ($fp) fclose($fp);
	} else $rv=1;
	return $rv;
}

return;
?>
