<?php
/**********************

	TriggerNote Database Updater
	(c) Copyright 2015 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

**********************/

define('InTriggerNote',1);
define('UPDATING',1);
require_once dirname(__file__).'/admin-core.php';
?>
<!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>TriggerNote Updater</title>
	<style type="text/css">
	body {
		background-color:#fff;
	}
	body, td, input {
		font-family:Arial,Helvetica,sans serif;
		font-size:11pt;
	}
	#header,#content {
		position:relative;
		left:50%;
		margin-left:-350px;
		width:700px;
	}
	#header {
		background-color:#03c;
		color:#fff;
		font-weight:bold;
		font-size:25pt;
		letter-spacing:-2px;
		padding:5px 15px;
	}
	#content {
		padding:12px 0;
	}
	</style>
</head>
<body>

<div id="header">
	TriggerNote Updater
</div>

<div id="content">

<?php
if (isset($_REQUEST['doupdate'])) {
	$skipDBErrors=isset($_GET['skipDBErrors'])?floor($_GET['skipDBErrors']):0;
	$TriggerNote_db=array(
		'db_version'=>'2',
		'db_prefix'=>'',
		'db_name'=>'',
		'db_host'=>'localhost',
		'db_port'=>'',
		'db_user'=>'',
		'db_pass'=>''
	);
	require_once '../default-conf.php';
	$new_db_version=$TriggerNote['db_version'];
	$old_db_version=0;

	function LoadOldConf() {
		global $TriggerNote,$TriggerNote_db,$old_db_version;
		if ($conf=file_get_contents(dirname(__file__).'/../myconf.php')) {
			$confs=explode("\n",preg_replace('/[\\r\\n]+/',"\n",substr($conf,strpos($conf,'>')+1)));
			foreach ($confs as $conf) if (strlen(trim($conf))) {
				list($k,$v)=explode('=',$conf,2);
				if (substr($k,0,3)=='db_') $TriggerNote_db[$k]=trim($v);
				else $TriggerNote[$k]=trim($v);
			}
			if (trigger_note_db_connect($TriggerNote_db['db_host'].(isset($TriggerNote_db['db_port']{0})?":{$TriggerNote_db['db_port']}":''),$TriggerNote_db['db_user'],$TriggerNote_db['db_pass'],$TriggerNote_db['db_name'])) {
				if ($r=trigger_note_db_q("select conf from `$TriggerNote_db[db_prefix]TriggerNote_conf`",'conf')) {
					if ($oldConf=json_decode($r,1)) {
						$old_db_version=isset($_GET['force_old_version'])?$_GET['force_old_version']:$oldConf['db_version'];
						foreach ($oldConf as $k=>$v) $TriggerNote[$k]=$v;
					} else {
						echo 'Failed to decode settings stored in database.';
						return 0;
					}
				}
			} else {
				echo 'Failed to connect to MySQL.';
				return 0;
			}
		} else {
			echo 'Failed to load old configuration settings file.';
			return 0;
		}
		return 1;
	}

	function FixDatabase() {
		global $TriggerNote,$TriggerNote_db,$old_db_version,$new_db_version,$skipDBErrors;
		$db_prefix=$TriggerNote_db['db_prefix'];

		if ($old_db_version<2) {
			echo '<p>Updating Trigger Set table...';
			flush();
			if ((!trigger_note_db_x('alter table `'.$db_prefix.'TriggerNoteTriggerSet` add tnts_style text'))&&!($skipDBErrors&1))
				{ trigger_note_db_error('').'</p>'; if (!$skipDBErrors) return 0; }
			echo 'done.</p>';
		}

		if ($old_db_version<3) {
			echo '<p>Creating split test table...';
			flush();
			if ((!trigger_note_db_x('create table `'.$db_prefix.'TriggerNoteSplitTest` (tnst_id int primary key auto_increment,
tnst_name varchar(60),
tnst_selector_group varchar(30) not null,
index(tnst_selector_group),
tnst_priority int,
tnst_data text)'))&&!($skipDBErrors&1))
				{ trigger_note_db_error('').'</p>'; if (!$skipDBErrors) return 0; }
			echo 'done.</p>';
		}

		if ($old_db_version<4) {
			echo '<p>Creating analytics table...';
			flush();
			if ((!trigger_note_db_x('create table `'.$db_prefix.'TriggerNoteAnalytics` (tna_key varchar(30) not null,
index(tna_key),
tna_refreshed bigint,
tna_start_date date,
tna_end_date date,
tna_data text)'))&&!($skipDBErrors&1))
				{ trigger_note_db_error('').'</p>'; if (!$skipDBErrors) return 0; }
			echo 'done.</p>';
		}
		echo '<p>Storing configuration...';
		flush();
		$TriggerNote['db_version']=$new_db_version;
		if (trigger_note_db_x('insert into `'.$db_prefix.'TriggerNote_conf` set conf="'.addslashes(json_encode($TriggerNote)).'"')) {
			if (!trigger_note_db_x('delete from `'.$db_prefix.'TriggerNote_conf` where cid!='.trigger_note_db_insert_id()))
				{ trigger_note_db_error(''); if (!$skipDBErrors) return 0; }
		} else { trigger_note_db_error('').'</p>'; if (!$skipDBErrors) return 0; }
		echo 'done.</p>';

		return 1;
	}

	if (LoadOldConf()) {
		if (FixDatabase()) {
			if ($old_db_version<1) ShowNewConf();
			else echo '<p>Update complete. <a href="controlpanel.php">Continue</a>.</p>';
		}
	}
} else { ?>
	<form action="update.php" method="post">
	<p>To update your database to the latest version, click <input type="submit" name="doupdate" value="Continue"></p>
	</form>
<?php } ?>

</div>

</body>
</html>
