<?php
/**********************

	TriggerNote
	(c) Copyright 2015-8 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

**********************/

global $TriggerNote,$TriggerNote_db,$TriggerNote_version,$trigger_note_path;
$TriggerNote_version='1.6.3';
$TriggerNote_db=array(
	'db_version'=>'4',
	'db_prefix'=>'',
	'db_name'=>'',
	'db_host'=>'localhost',
	'db_port'=>'',
	'db_user'=>'',
	'db_pass'=>''
);

$trigger_note_path=substr(dirname(__file__),strlen($_SERVER['DOCUMENT_ROOT']));

function TriggerNoteStartup() {
	global $TriggerNote,$TriggerNote_db,$trigger_note_path;
	if (!defined('installing')) {
		if (!file_exists(dirname(__file__).'/myconf.php')) {
			if (defined('TriggerNoteAdmin')) {
				echo 'Unable to find myconf.php. Please run the <a href="'.$trigger_note_path.'/install.php">installation script</a> to create this file.';
				exit;
			}
		} else {
			if ($conf=file_get_contents(dirname(__file__).'/myconf.php')) {
				$confs=explode("\n",preg_replace('/[\\r\\n]+/',"\n",substr($conf,strpos($conf,'>')+1)));
				foreach ($confs as $conf) if (strlen(trim($conf))) {
					list($k,$v)=explode('=',trim($conf),2);
					if ($k=='symlink_path') {
						list($k,$v)=explode('=',$v,2);
						if ($_SERVER['HTTP_HOST']==$k) $trigger_note_path=$v;
					} else if ($k!='db_version') $TriggerNote_db[$k]=$v;
				}
				$mayBeEmpty=array('db_prefix','db_port');
				foreach ($TriggerNote_db as $k=>$v) if ((!strlen("$v"))&&!in_array($k,$mayBeEmpty)) {
					if (defined('TriggerNoteAdmin')) {
						echo 'Error: the '.$k.' setting in your configuration file is empty -- check the README for installation instructions. ';
						exit;
					}
				}
			} else if (defined('TriggerNoteAdmin')) {
				echo 'Failed to load myconf.php -- check the README for installation instructions. ';
				exit;
			}
		}

		if (isset($TriggerNote_db['db_name']{0})) {
			if (trigger_note_db_connect($TriggerNote_db['db_host'].(isset($TriggerNote_db['db_port']{0})?":{$TriggerNote_db['db_port']}":''),$TriggerNote_db['db_user'],$TriggerNote_db['db_pass'],$TriggerNote_db['db_name'])) {
				if ($TriggerNote=trigger_note_db_q("select conf from `{$TriggerNote_db['db_prefix']}TriggerNote_conf`",'conf')) {
					$TriggerNote=json_decode($TriggerNote,1);
					if (($TriggerNote['db_version']!=$TriggerNote_db['db_version'])&&defined('TriggerNoteAdmin')&&!defined('UPDATING')) {
						header('Location: update.php');
						exit;
					}
					if ($TriggerNote['debug']) {
						error_reporting(E_ALL);
						ini_set('display_errors',1);
					}
				} else echo 'Failed to load configuration from database. ';
			} else echo 'Failed to connect to database. ';
		}
	}
}
TriggerNoteStartup();

function trigger_note_db_connect($h,$u,$p,$d) {
	global $TriggerNote_db;
	if (!(isset($TriggerNote_db['method'])&&isset($TriggerNote_db['method']{0})))
		$TriggerNote_db['method']=function_exists('mysql_connect')?'mysql':'mysqli';
	switch($TriggerNote_db['method']) {
	case 'mysql': if ($TriggerNote_db['dbh']=mysql_connect($h,$u,$p,true)) mysql_select_db($d,$TriggerNote_db['dbh']); break;
	case 'mysqli': $TriggerNote_db['dbh']=mysqli_connect($h,$u,$p,$d); break;
	}
	return $TriggerNote_db['dbh'];
}

function trigger_note_db_error($m,$echo=1) {
	global $TriggerNote_db;
	$err=$m.'<p>['.(($TriggerNote_db['method']=='mysql')?mysql_error($TriggerNote_db['dbh']):mysqli_error($TriggerNote_db['dbh'])).']</p>';
	if ($echo) echo $err;
	return $err;
}

function trigger_note_db_insert_id() {
	global $TriggerNote_db;
	return ($TriggerNote_db['method']=='mysql')?mysql_insert_id():mysqli_insert_id($TriggerNote_db['dbh']);
}

function trigger_note_db_x($q) {
	global $TriggerNote_db;
	return ($TriggerNote_db['method']=='mysql')?mysql_query($q,$TriggerNote_db['dbh']):mysqli_query($TriggerNote_db['dbh'],$q);
}
function trigger_note_db_q($q,$oneField=false) {
	global $TriggerNote_db;
	$rv=false;
	if ($r=(($TriggerNote_db['method']=='mysql')?mysql_query($q,$TriggerNote_db['dbh']):mysqli_query($TriggerNote_db['dbh'],$q))) {
		if ($rv=(($TriggerNote_db['method']=='mysql')?mysql_fetch_array($r,MYSQL_ASSOC):mysqli_fetch_array($r,MYSQLI_ASSOC)))
			if ($oneField!==false) $rv=$rv[$oneField];
		if ($TriggerNote_db['method']=='mysql') mysql_free_result($r);
		else mysqli_free_result($r);
	}
	return $rv;
}
function trigger_note_db_q_all($q,&$data,$oneField=false) {
	global $TriggerNote_db;
	if ($r=(($TriggerNote_db['method']=='mysql')?mysql_query($q,$TriggerNote_db['dbh']):mysqli_query($TriggerNote_db['dbh'],$q))) {
		$rv=1;
		$data=array();
		while ($l=(($TriggerNote_db['method']=='mysql')?mysql_fetch_array($r,MYSQL_ASSOC):mysqli_fetch_array($r,MYSQLI_ASSOC)))
			$data[]=($oneField===false)?$l:$l[$oneField];
		if ($TriggerNote_db['method']=='mysql') mysql_free_result($r);
		else mysqli_free_result($r);
	} else $rv=0;
	return $rv;
}

return;
?>
