<?php
/**********************

	TriggerNote JavaScript
	(c) Copyright 2015 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

**********************/

global $TriggerNoteSerial;

require_once dirname(__file__).'/TriggerNote.php';

function TriggerNoteJSFile($f,$op,&$o) {
	$f=preg_replace('/\\.{2,}/','.',preg_replace('#[^-_a-zA-Z0-9./]#','',$f));
	if ($op=='t') return filemtime(dirname(__file__)."/$f.php");
	ob_start();
	include dirname(__file__)."/$f.php";
	$o.=preg_replace('#^/\\*.*?\\*\\*/#s','',ob_get_contents());
	ob_end_clean();
}

$modtime=filemtime(__file__);
$output='';
$modtime=max($modtime,TriggerNoteJSFile('TriggerNote-JS','t',$output));

function PluginFN2ON($fn) {
	return preg_replace_callback('/(^|-)([a-z])/',function($m){return strtoupper($m[2]);},$fn);
}

function AddActionJS(&$data) {
	global $TriggerNoteSerial;
	if (isset($data['id'])&&isset($data['id']{0})) $id=$data['id'];
	else {
		$id="tn$TriggerNoteSerial";
		$TriggerNoteSerial++;
	}
	echo 'TriggerNoteTemp[0].AddAction("'.addslashes($id).'",new TriggerNoteA'.PluginFN2ON($data['type']).'('.json_encode($data['o']).'));';
}

function AddTriggerJS(&$data) { 
	global $TriggerNoteSerial;
	if (isset($data['id'])&&isset($data['id']{0})) $id=$data['id'];
	else {
		$id="tn$TriggerNoteSerial";
		$TriggerNoteSerial++;
	}
	echo 'TriggerNoteTemp.unshift(new TriggerNoteT'.PluginFN2ON($data['type']).'('.json_encode($data['o']).'));'
		.'TriggerNoteTemp[1].AddTest("'.addslashes($id).'",TriggerNoteTemp[0]);';
	if (isset($data['a'])) foreach ($data['a'] as &$one) AddActionJS($one);
	if (($data['type']=='group')&&isset($data['tc'])) foreach ($data['tc'] as &$one) AddTriggerJS($one);
	echo 'TriggerNoteTemp.shift();';
}

if (trigger_note_db_q_all("select * from `$TriggerNote_db[db_prefix]TriggerNoteTriggerSet` where tnts_id in (".preg_replace('/[^,0-9]/','',$_GET['ts']).')',$allTS)) {
	$scripts=array('trigger'=>array(),'action'=>array());
	foreach ($allTS as &$one) {
		if ($one['tnts_updated']>$modtime) $modtime=$one['tnts_updated'];
		$one['tnts_plugins']=json_decode($one['tnts_plugins'],1);
		foreach ($one['tnts_plugins']['trigger'] as $n) if (!in_array($n,$scripts['trigger'])) $scripts['trigger'][]=$n;
		foreach ($one['tnts_plugins']['action'] as $n) if (!in_array($n,$scripts['action'])) $scripts['action'][]=$n;
	}
	foreach ($scripts['trigger'] as $n) $modtime=max($modtime,TriggerNoteJSFile("triggers/$n",'t',$output));
	foreach ($scripts['action'] as $n) $modtime=max($modtime,TriggerNoteJSFile("actions/$n",'t',$output));

	$last=gmdate('D, d M Y H:i:s \G\M\T',$modtime);
	if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])&&($_SERVER['HTTP_IF_MODIFIED_SINCE']==$last)) {
		header('HTTP/1.0 304 Not Modified');
		header('Content-Type: text/javascript');
		exit;
	}

	header('Content-Type: text/javascript');
	header('Last-Modified: '.$last);
	?>
	/**********************

		TriggerNote
		(c) Copyright 2015 Gecko Tribe, LLC
		All Rights Reserved
		by Antone Roundy

		*** THIS IS NOT FREE SOFTWARE ***

		Unauthorized copying and creating
		derivative code based on parts of this
		code are forbidden by copyright law.
		If you're going to use this script or
		any part of it, please do so legally
		and honestly by buying a copy at:

		http://www.geckotribe.com/TriggerNote/

		Thank you.  Your honesty makes it possible
		for me to take time from other work to
		create and support scripts like this.

	**********************/
	<?php
	TriggerNoteJSFile('TriggerNote-JS','',$output);
	foreach ($scripts['trigger'] as $n) TriggerNoteJSFile("triggers/$n",'',$output);
	foreach ($scripts['action'] as $n) TriggerNoteJSFile("actions/$n",'',$output);
	echo preg_replace('/[ \t]*[\r\n]+[ \t]*/','',$output);
	$TriggerNoteSerial=1;
	echo 'TriggerNoteInited=0;TriggerNoteTemp=[TriggerNote=new TriggerNoteList()];';
	foreach ($allTS as &$one) {
		$one['tnts_data']=json_decode($one['tnts_data'],1);
		AddTriggerJS($one['tnts_data']);
	}
	echo 'TriggerNoteTemp.shift();TriggerNoteInited=1;';
}
?>
