<?php header('Content-Type: text/css'); ?>
/**********************

	TriggerNote Stylesheet
	(c) Copyright 2015-8 Gecko Tribe, LLC
	All Rights Reserved
	by Antone Roundy

**********************/

.TriggerNoteNoShow { display:none; }

.TriggerNoteHover {
	position:absolute;
	top:35px;
	left:50%;
	margin-left:-300px;
	width:600px;
	z-index:100001;
	background-color:#f6f6f6;
	border:5px solid #3b66c7;
	padding:12px 20px;
	border-radius:12px;
}
.TriggerNoteHover *:first-child, *:nth-child(2) { margin-top:0; }
.TriggerNoteHover *:last-child { margin-bottom:0; }
.TriggerNoteHoverCloser {
	position:absolute;
	top:-18px;
	right:-18px;
	z-index:1000;
}
div.TriggerNoteHoverCloser {
	width:32px;
	height:32px;
	border-radius:16px;
	background-image:url(img/x-w-32.png);
	background-color:#3b66c7;
}
div.TriggerNoteInnerCloser {
	float:right;
	margin:-4px -11px 5px 15px!important;
	width:20px;
	height:20px;
	background-image:url(img/delete.png);
}
.TriggerNoteBorderless .TriggerNoteHoverCloser, .TriggerNoteBorderline .TriggerNoteHoverCloser {
	top:-16px;
	right:-16px;
}
div.TriggerNoteHoverCloser:hover, div.TriggerNoteInnerCloser:hover { cursor:pointer; }
.TriggerNotePageCover, .TriggerNotePageGray {
	position:fixed;
	top:0;
	left:0;
	height:100vh;
	width:100vw;
	z-index:100000;	
}
.TriggerNotePageGray {
	background-color:#3c4043;
	opacity: 0.8;
	filter:alpha(opacity=80);
}
.TriggerNotePageCover .TriggerNoteHover {
	position:relative;
	left:0;
	margin-left:auto!important;
	margin-right:auto;
	max-width:100%;
}

#TriggerNoteStripeTop, #TriggerNoteStripeBottom {
	display:flex;
	justify-content:space-between;
	height:100vh;
}
#TriggerNoteStripeTop { flex-direction:column; }
#TriggerNoteStripeBottom { flex-direction:column-reverse; }
#TriggerNoteStripeTop>div, #TriggerNoteStripeBottom>div { position:relative; }
#TriggerNoteStripeTop>div:first-child, #TriggerNoteStripeBottom>div:first-child {
	flex:0 0 46px;
	background-color:#f93;
	color:#fff;
	padding:5px 12px;
	z-index:2;
	-webkit-transition:100ms linear;
	-moz-transition:100ms linear;
	-o-transition:100ms linear;
	-ms-transition:100ms linear;
	transition:100ms linear;
}
#TriggerNoteStripeTop.TriggerNoteStripeClosed>div:first-child,
	#TriggerNoteStripeBottom.TriggerNoteStripeClosed>div:first-child
	{
		flex:0 0 1px!important;
		padding:0 12px;
	}
#TriggerNoteStripeTop>div:first-child>div:first-child,
	#TriggerNoteStripeBottom>div:first-child>div:first-child
	{
		overflow:hidden;
		margin-right:35px;
	}
#TriggerNoteStripeTop.TriggerNoteStripeClosed>div:first-child>div:first-child,
	#TriggerNoteStripeBottom.TriggerNoteStripeClosed>div:first-child>div:first-child
	{ height:1px; }
.TriggerNoteStripeOpener, .TriggerNoteStripeCloser {
	position:absolute;
	right:15px;
}
.TriggerNoteStripeCloser {
	top:50%;
	margin-top:-10px;
}
.TriggerNoteStripeOpener {
	background-color:#f93;
	height:24px;
	width:24px;
	text-align:center;
	font-family:Arial,Helvetica,sans serif;
	font-size:14pt;
}
#TriggerNoteStripeTop .TriggerNoteStripeOpener {
	bottom:-24px;
	border-radius:0 0 5px 5px;
}
#TriggerNoteStripeBottom .TriggerNoteStripeOpener {
	top:-24px;
	border-radius:5px 5px 0 0;
}
#TriggerNoteStripeTop.TriggerNoteStripeClosed>div:first-child>.TriggerNoteStripeCloser,
	#TriggerNoteStripeBottom.TriggerNoteStripeClosed>div:first-child>.TriggerNoteStripeCloser
	{ display:none; }
#TriggerNoteStripeTop>div:first-child>.TriggerNoteStripeOpener,
	#TriggerNoteStripeBottom>div:first-child>.TriggerNoteStripeOpener
	{ display:none; }
#TriggerNoteStripeTop.TriggerNoteStripeClosed>div:first-child>.TriggerNoteStripeOpener,
	#TriggerNoteStripeBottom.TriggerNoteStripeClosed>div:first-child>.TriggerNoteStripeOpener
	{ display:block; }
#TriggerNoteStripeTop>div:last-child, #TriggerNoteStripeBottom>div:last-child {
	flex:1 1 auto;
	overflow:auto;
	padding:8px;
}

#TriggerNoteSlideInRight, #TriggerNoteSlideInLeft {
	position:fixed;
	bottom:15px;
	z-index:99900;
}
#TriggerNoteSlideInRight { right:0; }
#TriggerNoteSlideInLeft { left:0; }
.TriggerNoteSlideInStyle, #TriggerNoteSlideInStyle {
	overflow:hidden;
	padding:10px 18px;
	background-color:#f3f3f3;
	border:5px solid #53595f;
}
#TriggerNoteSlideInRight>.TriggerNoteSlideInStyle, #TriggerNoteSlideInRight>#TriggerNoteSlideInStyle {
	border-right-width:0;
	border-radius:0 0 0 18px;
}
#TriggerNoteSlideInLeft>.TriggerNoteSlideInStyle, #TriggerNoteSlideInLeft>#TriggerNoteSlideInStyle {
	border-left-width:0;
	border-radius:0 0 18px 0;
}
#TriggerNoteSlideInRight.TriggerNoteNoCloser>.TriggerNoteSlideInStyle, #TriggerNoteSlideInRight.TriggerNoteNoCloser>#TriggerNoteSlideInStyle {
	border-radius:18px 0 0 18px;
}
#TriggerNoteSlideInLeft.TriggerNoteNoCloser>.TriggerNoteSlideInStyle, #TriggerNoteSlideInLeft.TriggerNoteNoCloser>#TriggerNoteSlideInStyle {
	border-radius:0 18px 18px 0;
}
#TriggerNoteSlideInRight, #TriggerNoteSlideInLeft,
	#TriggerNoteSlideInRight>.TriggerNoteSlideInStyle, #TriggerNoteSlideInLeft>.TriggerNoteSlideInStyle,
	#TriggerNoteSlideInRight>#TriggerNoteSlideInStyle, #TriggerNoteSlideInLeft>#TriggerNoteSlideInStyle
{
  	-webkit-transition:250ms linear;
	-moz-transition:250ms linear;
	-o-transition:250ms linear;
	-ms-transition:250ms linear;
	transition:250ms linear;
}
#TriggerNoteSlideInRight.TriggerNoteSlideInClosed, #TriggerNoteSlideInLeft.TriggerNoteSlideInClosed { width:0!important; }
#TriggerNoteSlideInRight.TriggerNoteSlideInClosed { right:-41px; }
#TriggerNoteSlideInLeft.TriggerNoteSlideInClosed { left:-41px; }
.TriggerNoteSlideInCloser {
	position:absolute;
	top:-7px;
	z-index:2;
}
#TriggerNoteSlideInRight .TriggerNoteSlideInCloser { left:-7px; }
#TriggerNoteSlideInLeft .TriggerNoteSlideInCloser { right:-7px; }
#TriggerNoteSlideInContent { width:100%; }

.TriggerNoteSlideInOpener {
	position:absolute;
	bottom:7px;
	background-color:#f93;
	height:24px;
	width:24px;
	text-align:center;
	font-family:Arial,Helvetica,sans serif;
	font-size:14pt;
	display:none;
	z-index:2;
}
.TriggerNoteSlideInClosed .TriggerNoteSlideInOpener { display:block; }
#TriggerNoteSlideInRight .TriggerNoteSlideInOpener {
	left:-65px;
	border-radius:5px 0 0 5px;
}
#TriggerNoteSlideInLeft .TriggerNoteSlideInOpener {
	right:-41px;
	border-radius:0 5px 5px 0;
}

.TriggerNoteXSFont, .TriggerNoteXSFont td, .TriggerNoteXSFont input, .TriggerNoteXSFont select, .TriggerNoteXSFont button, .TriggerNoteXSFont textarea { font-size:10pt; }
.TriggerNoteSFont, .TriggerNoteSFont td, .TriggerNoteSFont input, .TriggerNoteSFont select, .TriggerNoteSFont button, .TriggerNoteSFont textarea { font-size:12pt; }
.TriggerNoteMFont, .TriggerNoteMFont td, .TriggerNoteMFont input, .TriggerNoteMFont select, .TriggerNoteMFont button, .TriggerNoteMFont textarea { font-size:14pt; }
.TriggerNoteLFont, .TriggerNoteLFont td, .TriggerNoteLFont input, .TriggerNoteLFont select, .TriggerNoteLFont button, .TriggerNoteLFont textarea { font-size:16pt; }
.TriggerNoteXLFont, .TriggerNoteXLFont td, .TriggerNoteXLFont input, .TriggerNoteXLFont select, .TriggerNoteXLFont button, .TriggerNoteXLFont textarea { font-size:18pt; }

.TriggerNoteSquare { border-radius:0; }
.TriggerNoteBorderless { border-width:0; }
.TriggerNoteBorderline { border-width:1px; }

.TriggerNoteButton1 input[type="submit"], .TriggerNoteButton1 input[type="button"],
	input.TriggerNoteButton1
{
	appearance:none;
	font-weight:bold;
	font-size:105%;
	padding:0.1em 0.8em;
	margin:2px;
}
.TriggerNoteButton2 input[type="submit"], .TriggerNoteButton2 input[type="button"],
	input.TriggerNoteButton2
{
	appearance:none;
	font-weight:bold;
	font-size:110%;
	padding:0.4em 1.2em;
	margin:2px;
}
.TriggerNoteButton3 input[type="submit"], .TriggerNoteButton3 input[type="button"],
	input.TriggerNoteButton3
{
	appearance:none;
	font-weight:bold;
	font-size:120%;
	padding:0.7em 1.5em;
	margin:2px;
}
.TriggerNoteRoundButton1 input[type="submit"], .TriggerNoteRoundButton1 input[type="button"] { border-radius:10px; }
.TriggerNoteRoundButton2 input[type="submit"], .TriggerNoteRoundButton2 input[type="button"] { border-radius:25px; }
.TriggerNoteRoundButton3 input[type="submit"], .TriggerNoteRoundButton3 input[type="button"] { border-radius:40px; }
.TriggerNoteBorderlessButton input[type="submit"], .TriggerNoteBorderlessButton input[type="button"], input.TriggerNoteBorderlessButton { border:none; }
.TriggerNoteBorderlineButton input[type="submit"], .TriggerNoteBorderlineButton input[type="button"], input.TriggerNoteBorderlineButton { border:1px solid #555; }
.TriggerNoteThickBorderButton input[type="submit"], .TriggerNoteThickBorderButton input[type="button"] { border:0.44em solid #555; }

<?php
require_once dirname(__file__).'/TriggerNote.php';
if (trigger_note_db_q_all("select tnts_style from `$TriggerNote_db[db_prefix]TriggerNoteTriggerSet` where tnts_id in (".preg_replace('/[^,0-9]/','',$_GET['ts']).')',$allTS,'tnts_style')) {
	$allSS=array();
	foreach ($allTS as $one) if (isset($one{0})) {
		$one=json_decode($one);
		foreach ($one as $ss) if (!in_array($ss,$allSS)) $allSS[]=$ss;
	}
	foreach ($allSS as $one) include dirname(__file__)."/style".preg_replace('/\\.{2,}/','.',preg_replace('#[^-a-zA-Z0-9/_.]#','',$one));
}
include dirname(__file__).'/user-style.css';
foreach (explode(',',$_GET['ts']) as $one) if (file_exists($fn=(dirname(__file__).'/user-style/'.$one.'.css'))) include $fn;
?>
