<?php
/*
==============================================================================
Plugin Name: TriggerNote/WP
Version: 1.2.2
Plugin URI: http://www.geckotribe.com/TriggerNote/
Description: Connects WordPress to TriggerNote
Author: Antone Roundy
Author URI: http://whitehatcrew.com/blog/
==============================================================================
(c) Copyright 2016-7 Gecko Tribe, LLC
All Rights Reserved
*/

define('InTriggerNote',1);

$trigger_note_wp_url = get_bloginfo('wpurl').'/wp-content/plugins/TriggerNoteWP/';
$trigger_note_wp_admin_options_name = "trigger_note_wp_plugin_admin_options";
$trigger_note_wp_version = '1.2';
$trigger_note_wp_options='';

function TriggerNoteAttemptLocate() {
	$rv='';
	$pathparts=explode('/',dirname(__file__));
	while (count($pathparts)) {
		array_pop($pathparts);
		if (file_exists($path=(implode('/',$pathparts).'/TriggerNote/TriggerNote.php'))) {
			$rv=$path;
			break;
		}
	}
	return $rv;
}

function TriggerNoteWP_save_post($post_id) {
	include_once dirname(__FILE__).'/inc/post.php';
	return TriggerNoteWPSavePost($post_id);
}

function TriggerNoteWP_page_form($post_id) {
	include_once dirname(__FILE__).'/inc/post.php';
	return TriggerNoteWPPageForm($post_id);
}

function TriggerNoteWP_old_page_form($post_id) {
	include_once dirname(__FILE__).'/inc/post.php';
	return TriggerNoteWPOldPageForm($post_id);
}

function trigger_note_wp_print_admin_options() { include dirname(__FILE__).'/inc/admin.php'; }

if (!function_exists('trigger_note_wp_admin_menu')) {
	function trigger_note_wp_admin_menu() {
		if (function_exists('add_options_page')) {
			add_options_page('TriggerNote/WP', 'TriggerNote/WP', 9, basename(__FILE__), trigger_note_wp_print_admin_options);
			if( function_exists('add_meta_box')) {
				add_meta_box('trigger_note_wp_sectionid','TriggerNote/WP','TriggerNoteWP_page_form','post','advanced');
				add_meta_box('trigger_note_wp_sectionid','TriggerNote/WP','TriggerNoteWP_page_form','page','advanced');
			} else {
				add_action('dbx_post_advanced','TriggerNoteWP_old_page_form');
				add_action('dbx_page_advanced','TriggerNoteWP_old_page_form');
			}
		}
	}
}

function trigger_note_wp_load_options($defaults=0) {
	global $trigger_note_wp_options, $trigger_note_wp_admin_options_name;
	if (is_array($trigger_note_wp_options)) return $trigger_note_wp_options;
	$trigger_note_wp_options=array(
		'install_path'=>TriggerNoteAttemptLocate()
		,'default_trigger_sets'=>array()
		,'default_split_tests'=>array()
		,'default_selector_groups'=>array()
	);	
	if (!$defaults) {
		$saved_options=get_option($trigger_note_wp_admin_options_name);
		if (!empty($saved_options)) {
			if (isset($saved_options['default_trigger_set'])) $trigger_note_wp_options['default_trigger_sets']=array($saved_options['default_trigger_set']);
			foreach ($trigger_note_wp_options as $k=>$v) if (isset($saved_options[$k])) $trigger_note_wp_options[$k]=$saved_options[$k];
		}
	}
	return $trigger_note_wp_options;
}

function trigger_note_wp_head() {
	global $trigger_note_wp_options,$TriggerNoteTriggerSetsToUse,$wp_query;
	trigger_note_wp_load_options();
	$triggersets=isset($trigger_note_wp_options['default_trigger_set'])?array($trigger_note_wp_options['default_trigger_set']):$trigger_note_wp_options['default_trigger_sets'];
	$splittests=isset($trigger_note_wp_options['default_split_tests'])?$trigger_note_wp_options['default_split_tests']:array();
	$selectorgroups=isset($trigger_note_wp_options['default_selector_groups'])?$trigger_note_wp_options['default_selector_groups']:array();
	
	if ((is_single()||is_page())&&isset($wp_query->post)&&$wp_query->post->ID) {
		$mydata=get_post_meta($wp_query->post->ID,'TriggerNote');
		if (is_array($mydata)&&is_array($mydata[0])) {
			if (isset($mydata[0]['trigger_set'])) {
				if ($mydata[0]['trigger_set']==-1) $triggersets=array();
				else if ($mydata[0]['trigger_set']!=-2) $triggersets=($mydata[0]['trigger_set']);
			} else if (isset($mydata[0]['trigger_sets'])&&count(($mydata[0]['trigger_sets']))) {
				if (in_array(-2,$mydata[0]['trigger_sets'])) {
					array_splice($mydata[0]['trigger_sets'],array_search(-2,$mydata[0]['trigger_sets']),1);
					$triggersets=array_merge($triggersets,$mydata[0]['trigger_sets']);
				} else $triggersets=$mydata[0]['trigger_sets'];
			}
			if (in_array(-1,$triggersets)) $triggersets=array();
			if (isset($mydata[0]['split_tests'])&&count(($mydata[0]['split_tests']))) {
				if (in_array(-2,$mydata[0]['split_tests'])) {
					array_splice($mydata[0]['split_tests'],array_search(-2,$mydata[0]['split_tests']),1);
					$splittests=array_merge($splittests,$mydata[0]['split_tests']);
				} else $splittests=$mydata[0]['split_tests'];
			}
			if (in_array(-1,$splittests)) $splittests=array();
			if (isset($mydata[0]['selector_groups'])&&count(($mydata[0]['selector_groups']))) {
				if (in_array(-2,$mydata[0]['selector_groups'])) {
					array_splice($mydata[0]['selector_groups'],array_search(-2,$mydata[0]['selector_groups']),1);
					$selectorgroups=array_merge($selectorgroups,$mydata[0]['selector_groups']);
				} else $selectorgroups=$mydata[0]['selector_groups'];
			}
			if (in_array(-1,$selectorgroups)) $selectorgroups=array();
		}
	}
	if (count($triggersets)||count($splittests)||count($selectorgroups)) {
		include_once $trigger_note_wp_options['install_path'];
		foreach ($triggersets as $one) if ($one) TriggerNoteUseTriggerSet($one);
		else TriggerNoteAutoSelect();
		foreach ($splittests as $one) TriggerNoteUseSplitTest($one);
		if (count($selectorgroups)) TriggerNoteUseSelectorGroups($selectorgroups);
		if (count($TriggerNoteTriggerSetsToUse)) TriggerNoteHead();
	}
}

function trigger_note_wp_footer() {
	global $TriggerNoteTriggerSetsToUse;
	if (count($TriggerNoteTriggerSetsToUse)) TriggerNoteBody();
}

function trigger_note_wp_init() {
	global $trigger_note_wp_options;
	add_filter('wp_head','trigger_note_wp_head');
	add_filter('wp_footer','trigger_note_wp_footer');
	if (isset($trigger_note_wp_options['install_path']{0})) include_once $trigger_note_wp_options['install_path'];
}

function trigger_note_wp_admin_head() { ?>	
	<style type="text/css"> .trigger_note_wp_table td { padding:2px 5px; } </style>
<?php }

add_action('activate_trigger_note_wp/trigger_note_wp.php', 'trigger_note_wp_load_options');
add_action('admin_menu', 'trigger_note_wp_admin_menu');
add_action('admin_head', 'trigger_note_wp_admin_head');
add_action('plugins_loaded', 'trigger_note_wp_init');
add_action('save_post','TriggerNoteWP_save_post');

return;
?>
