<?php
/*
TriggerNote/WP
http://www.geckotribe.com/TriggerNote/
Copyright 2015-6 Gecko Tribe, LLC
*/

global $trigger_note_wp_options,$trigger_note_wp_url,$trigger_note_wp_admin_options_name,$trigger_note_wp_version,$TriggerNote_db,$trigger_note_path;

if (isset($_REQUEST['restore'])) {
	trigger_note_wp_load_options(1);
	delete_option($trigger_note_wp_admin_options_name, $trigger_note_wp_options);
	echo '<div class="updated"><p><b>Settings restored to defaults.</b></p></div>';
} else trigger_note_wp_load_options();

if ($_POST['submit']) {
	$trigger_note_wp_local_error_msg='';
	if (isset($_POST['install_path'])&&isset($_POST['install_path']{0})) {
		$_POST['install_path']=stripslashes($_POST['install_path']);
		if (!file_exists($_POST['install_path'])) {
			$trigger_note_wp_local_error_msg.='<li>TriggerNote.php not found at "'.htmlspecialchars($_POST['install_path']).'.</li>';
			$_POST['install_path']='';
		} else $trigger_note_wp_options['install_path']=$_POST['install_path'];
	}
	
	$trigger_note_wp_options['default_trigger_sets']=array();
	$trigger_note_wp_options['default_split_tests']=array();
	$trigger_note_wp_options['default_selector_groups']=array();
	foreach ($_POST as $k=>$v)
		if (isset($v{0})&&(substr($k,0,24)=='Trigger_Note_trigger_set')) $trigger_note_wp_options['default_trigger_sets'][]=$v;	
		else if (isset($v{0})&&(substr($k,0,23)=='Trigger_Note_split_test')) $trigger_note_wp_options['default_split_tests'][]=$v;
		else if (isset($v{0})&&(substr($k,0,27)=='Trigger_Note_selector_group')) $trigger_note_wp_options['default_selector_groups'][]=$v;
	
	if ($trigger_note_wp_local_error_msg == '') {
		update_option($trigger_note_wp_admin_options_name, $trigger_note_wp_options);
		echo '<div class="updated"><p><b>Settings Updated.</b></p></div>';
	} else {
		 echo '<div class="error"><p><b>Failed to update settings:</b></p>';
		 echo '<ul>'.$trigger_note_wp_local_error_msg.'</ul></div>';
	}
}
if (!isset($trigger_note_wp_options['default_trigger_sets'])) $trigger_note_wp_options['default_trigger_sets']=array();
?>
<div class="wrap">
	<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
	<h2>TriggerNote/WP</h2>
	
	<p><a href="<?php $trigger_note_path; ?>/admin/controlpanel.php">Control Panel</a></p>
	
	<table border="0" cellspacing="0" cellpadding="3">
	<tr>
		<td>Install Path</td>
		<td><input type="text" name="install_path" value="<?php echo htmlspecialchars($trigger_note_wp_options['install_path']); ?>" size="60"/></td>
	</tr><tr>
		<td></td>
		<td>(full path to TriggerNote, including "TriggerNote.php")</td>
	</tr><tr>
		<td style="vertical-align:top;">Default Trigger Sets</td>
		<td colspan="2"><div style="max-height:300px;overflow:auto;">
			<input type="checkbox" name="Trigger_Note_trigger_set" id="Trigger_Note_trigger_set" value="0"<?php if (in_array(0,$trigger_note_wp_options['default_trigger_sets'])) echo ' checked'; ?>/>
				<label for="Trigger_Note_trigger_set">Auto-Select</label><br/>
			<?php
			if (file_exists($trigger_note_wp_options['install_path'])) {
				require_once $trigger_note_wp_options['install_path'];
				if (trigger_note_db_q_all("select tnts_id,tnts_name from `$TriggerNote_db[db_prefix]TriggerNoteTriggerSet` order by tnts_name",$TriggerNoteAllTriggerSets)) {
					foreach ($TriggerNoteAllTriggerSets as $TriggerNoteV)
						echo '<input type="checkbox" name="Trigger_Note_trigger_set'.$TriggerNoteV['tnts_id'].'" id="Trigger_Note_trigger_set'.$TriggerNoteV['tnts_id'].'"'
							.' value="'.$TriggerNoteV['tnts_id'].'"'.(in_array($TriggerNoteV['tnts_id'],$trigger_note_wp_options['default_trigger_sets'])?' checked':'')
							.'/><label for="Trigger_Note_trigger_set'.$TriggerNoteV['tnts_id'].'"> '.htmlspecialchars($TriggerNoteV['tnts_name']).'</label><br/>';
				}
			}
			?>
		</div></td>
	</tr><tr>
		<td style="vertical-align:top;">Default Split Tests</td>
		<td colspan="2"><div style="max-height:300px;overflow:auto;">
			<?php
			if (file_exists($trigger_note_wp_options['install_path'])) {
				if (trigger_note_db_q_all("select tnst_id,tnst_name from `$TriggerNote_db[db_prefix]TriggerNoteSplitTest` order by tnst_name",$TriggerNoteAllSplitTests)) {
					if (count($TriggerNoteAllSplitTests)) foreach ($TriggerNoteAllSplitTests as $TriggerNoteV)
						echo '<input type="checkbox" name="Trigger_Note_split_test'.$TriggerNoteV['tnst_id'].'" id="Trigger_Note_split_test'.$TriggerNoteV['tnst_id'].'"'
							.' value="'.$TriggerNoteV['tnst_id'].'"'.(in_array($TriggerNoteV['tnst_id'],$trigger_note_wp_options['default_split_tests'])?' checked':'')
							.'/><label for="Trigger_Note_split_test'.$TriggerNoteV['tnst_id'].'"> '.htmlspecialchars($TriggerNoteV['tnst_name']).'</label><br/>';
					 else echo 'No split tests configured.';
				}
			}
			?>
		</div></td>
	</tr><tr>
		<td style="vertical-align:top;">Default Selector Groups</td>
		<td colspan="2"><div style="max-height:300px;overflow:auto;">
			<?php
			if (file_exists($trigger_note_wp_options['install_path'])) {
				if (trigger_note_db_q_all("select tnss_data from `$TriggerNote_db[db_prefix]TriggerNoteSelectorSet`",$TriggerNoteAllSelectorSetsRaw,'tnss_data')) {
					if (count($TriggerNoteAllSelectorSetsRaw)) {
						$TriggerNoteAllSelectorSets=array();
						foreach ($TriggerNoteAllSelectorSetsRaw as $TriggerNoteV) if (isset($TriggerNoteV{0})) {
							$TriggerNoteV=json_decode($TriggerNoteV,1);
							if (isset($TriggerNoteV['group'])&&isset($TriggerNoteV['group']{0})&&!in_array($TriggerNoteV['group'],$TriggerNoteAllSelectorSets))
								$TriggerNoteAllSelectorSets[]=$TriggerNoteV['group'];
						}
						sort($TriggerNoteAllSelectorSets);
						foreach ($TriggerNoteAllSelectorSets as $TriggerNoteV) {
							$TriggerNoteVHash=md5($TriggerNoteV);
							echo '<input type="checkbox" name="Trigger_Note_selector_group'.$TriggerNoteVHash.'" id="Trigger_Note_selector_group'.$TriggerNoteVHash.'"'
								.' value="'.htmlspecialchars($TriggerNoteV).'"'.(in_array($TriggerNoteV,$trigger_note_wp_options['default_selector_groups'])?' checked':'')
								.'/><label for="Trigger_Note_selector_group'.$TriggerNoteVHash.'"> '.htmlspecialchars($TriggerNoteV).'</label><br/>';
						}
					} else echo 'No selector groups defined.';
				}
			}
			?>
		</div></td>
	</tr>
	</table>

	<div class="submit">
		<input type="submit" name="submit" id="submit" value="Update Settings" />
		<input type="submit" name="restore" id="restore" value="Reset Defaults" />
	</div>
	
	<hr style="margin:20px; 0 " />

	<p><b style="font-size:130%;">TriggerNote/WP</b></p>
	<p><b>Version:</b> <?php echo $trigger_note_wp_version; ?><br/>
	<b>Author:</b> Antone Roundy<br/>
	<b>Contact:</b> <a href="https://secure.geckotribe.com/helpdesk/">Contact</a>.</p>
	</form>	
</div><?php
return;
?>