<?php
/*
TriggerNote/WP
http://www.geckotribe.com/TriggerNote/
Copyright 2015-6 Gecko Tribe, LLC
*/

trigger_note_wp_load_options();

function TriggerNoteWPSavePost($post_id) {
	if (!wp_verify_nonce($_POST['TriggerNote_noncename'],plugin_basename(__FILE__))) return $post_id;
	if (!current_user_can(('page'==$_POST['post_type'])?'edit_page':'edit_post',$post_id)) return $post_id;

	$mydata=array('trigger_sets'=>array(),'split_tests'=>array(),'selector_groups'=>array());
	foreach ($_POST as $k=>$v)
		if (isset($v{0})&&(substr($k,0,24)=='Trigger_Note_trigger_set')) $mydata['trigger_sets'][]=$v;
		else if (isset($v{0})&&(substr($k,0,23)=='Trigger_Note_split_test')) $mydata['split_tests'][]=$v;
		else if (isset($v{0})&&(substr($k,0,27)=='Trigger_Note_selector_group')) $mydata['selector_groups'][]=$v;
	
	update_post_meta($post_id,'TriggerNote',$mydata);
	return $mydata;
}

function TriggerNoteWPPageForm() {
	global $post,$TriggerNote_db,$trigger_note_wp_options;
	echo '<input type="hidden" name="TriggerNote_noncename" id="TriggerNote_noncename" value="'.wp_create_nonce(plugin_basename(__FILE__)).'" />';

	$mydata=get_post_meta($post->ID,'TriggerNote');
	if (!is_array($mydata)) $mydata=array(array());
	else if (!count($mydata)) $mydata[0]=array();
	
	if (isset($mydata[0]['trigger_set'])) $mydata[0]['trigger_sets']=array($mydata[0]['trigger_set']);
	else if (!isset($mydata[0]['trigger_sets'])) $mydata[0]['trigger_sets']=array();
	if (!isset($mydata[0]['split_tests'])) $mydata[0]['split_tests']=array();
	if (!isset($mydata[0]['selector_groups'])) $mydata[0]['selector_groups']=array();
	?>
	<table cellspacing="0" class="TriggerNote_table">
	<tr>
		<td style="vertical-align:top;">Trigger Sets:</td>
		<td><div style="max-height:300px;overflow:auto;">
			<input type="checkbox" name="Trigger_Note_trigger_set_def" id="Trigger_Note_trigger_set_def" value="-2"<?php if (in_array(-2,$mydata[0]['trigger_sets'])||!count($mydata[0]['trigger_sets'])) echo ' checked'; ?>/>
				<label for="Trigger_Note_trigger_set_def">Default Setting</label><br/>
			<input type="checkbox" name="Trigger_Note_trigger_set_auto" id="Trigger_Note_trigger_set_auto" value="0"<?php if (in_array(0,$mydata[0]['trigger_sets'])) echo ' checked'; ?>/>
				<label for="Trigger_Note_trigger_set_auto">Auto-Select</label><br/>
			<input type="checkbox" name="Trigger_Note_trigger_set_none" id="Trigger_Note_trigger_set_none" value="-1"<?php if (in_array(-1,$mydata[0]['trigger_sets'])) echo ' checked'; ?>/>
				<label for="Trigger_Note_trigger_set_none">None</label><br/>
			<?php
			if (file_exists($trigger_note_wp_options['install_path'])) {
				require_once $trigger_note_wp_options['install_path'];
				if (trigger_note_db_q_all("select tnts_id,tnts_name from `$TriggerNote_db[db_prefix]TriggerNoteTriggerSet` order by tnts_name",$allsets)) {
					foreach ($allsets as $v)
						echo '<input type="checkbox" name="Trigger_Note_trigger_set'.$v['tnts_id'].'" id="Trigger_Note_trigger_set'.$v['tnts_id'].'"'
							.' value="'.$v['tnts_id'].'"'.(in_array($v['tnts_id'],$mydata[0]['trigger_sets'])?' checked':'')
							.'/><label for="Trigger_Note_trigger_set'.$v['tnts_id'].'"> '.htmlspecialchars($v['tnts_name']).'</label><br/>';
				}
			}
			?>
		</select></td>
	</tr><tr>
		<td style="vertical-align:top;">Split Tests:</td>
		<td><div style="max-height:300px;overflow:auto;">
			<input type="checkbox" name="Trigger_Note_split_test_def" id="Trigger_Note_split_test_def" value="-2"<?php if (in_array(-2,$mydata[0]['split_tests'])||!count($mydata[0]['split_tests'])) echo ' checked'; ?>/>
				<label for="Trigger_Note_split_test_def">Default Setting</label><br/>
			<input type="checkbox" name="Trigger_Note_split_test_none" id="Trigger_Note_split_test_none" value="-1"<?php if (in_array(-1,$mydata[0]['split_tests'])) echo ' checked'; ?>/>
				<label for="Trigger_Note_split_test_none">None</label><br/>
			<?php
			if (file_exists($trigger_note_wp_options['install_path'])) {
				if (trigger_note_db_q_all("select tnst_id,tnst_name from `$TriggerNote_db[db_prefix]TriggerNoteSplitTest` order by tnst_name",$allsplits)) {
					if (count($allsplits)) foreach ($allsplits as $v)
						echo '<input type="checkbox" name="Trigger_Note_split_test'.$v['tnst_id'].'" id="Trigger_Note_split_test'.$v['tnst_id'].'"'
							.' value="'.$v['tnst_id'].'"'.(in_array($v['tnst_id'],$mydata[0]['split_tests'])?' checked':'')
							.'/><label for="Trigger_Note_split_test'.$v['tnst_id'].'"> '.htmlspecialchars($v['tnst_name']).'</label><br/>';
					 else echo 'No split tests configured.';
				}
			}
			?>
		</select></td>
	</tr><tr>
		<td style="vertical-align:top;">Selector Groups:</td>
		<td><div style="max-height:300px;overflow:auto;">
			<input type="checkbox" name="Trigger_Note_selector_group_def" id="Trigger_Note_selector_group_def" value="-2"<?php if (in_array(-2,$mydata[0]['selector_groups'])||!count($mydata[0]['selector_groups'])) echo ' checked'; ?>/>
				<label for="Trigger_Note_selector_group_def">Default Setting</label><br/>
			<input type="checkbox" name="Trigger_Note_selector_group_none" id="Trigger_Note_selector_group_none" value="-1"<?php if (in_array(-1,$mydata[0]['selector_groups'])) echo ' checked'; ?>/>
				<label for="Trigger_Note_selector_group_none">None</label><br/>
			<?php
			if (file_exists($trigger_note_wp_options['install_path'])) {
				if (trigger_note_db_q_all("select tnss_data from `$TriggerNote_db[db_prefix]TriggerNoteSelectorSet`",$TriggerNoteAllSelectorSetsRaw,'tnss_data')) {
					if (count($TriggerNoteAllSelectorSetsRaw)) {
						$TriggerNoteAllSelectorSets=array();
						foreach ($TriggerNoteAllSelectorSetsRaw as $TriggerNoteV) if (isset($TriggerNoteV{0})) {
							$TriggerNoteV=json_decode($TriggerNoteV,1);
							if (isset($TriggerNoteV['group'])&&isset($TriggerNoteV['group']{0})&&!in_array($TriggerNoteV['group'],$TriggerNoteAllSelectorSets))
								$TriggerNoteAllSelectorSets[]=$TriggerNoteV['group'];
						}
						sort($TriggerNoteAllSelectorSets);
						foreach ($TriggerNoteAllSelectorSets as $TriggerNoteV) {
							$TriggerNoteVHash=md5($TriggerNoteV);
							echo '<input type="checkbox" name="Trigger_Note_selector_group'.$TriggerNoteVHash.'" id="Trigger_Note_selector_group'.$TriggerNoteVHash.'"'
								.' value="'.htmlspecialchars($TriggerNoteV).'"'.(in_array($TriggerNoteV,$mydata[0]['selector_groups'])?' checked':'')
								.'/><label for="Trigger_Note_selector_group'.$TriggerNoteVHash.'"> '.htmlspecialchars($TriggerNoteV).'</label><br/>';
						}
					} else echo 'No selector groups defined.';
				}
			}
			?>
		</select></td>
	</tr>
	</table>
	<?php
}

function TriggerNoteWPOldPageForm() {
	echo '<div class="dbx-b-ox-wrapper">'."\n".
		'<fieldset id="myplugin_fieldsetid" class="dbx-box">'."\n".
		'<div class="dbx-h-andle-wrapper"><h3 class="dbx-handle">TriggerNote</h3></div>'."\n".
		'<div class="dbx-c-ontent-wrapper"><div class="dbx-content">';
	TriggerNotePageForm();
	echo "</div></div></fieldset></div>\n";
}

return;
?>
