FR.components.ImageViewer=Ext.extend(Ext.Window,{unstyled:true,cls:"image-viewer",layout:"border",UI:{},closable:false,draggable:false,maximized:true,direction:false,image:false,zoomed:false,lastIndex:false,startIndex:-1,previewFrame:false,initComponent:function(){this.files=new Ext.util.MixedCollection;this.cached=new Ext.util.MixedCollection;this.initTasks();this.UI.filename=new Ext.Toolbar.TextItem({cls:"fr-prv-tbar-filename"});this.UI.status=new Ext.Toolbar.TextItem({cls:"fr-prv-tbar-status"});this.UI.zoomSlider=new Ext.Slider({width:110,minValue:0,maxValue:100,value:0,hidden:true,cls:"fr-prv-tbar-slider",listeners:{change:function(s,v){this.applyZoom.cancel();this.applyZoom.delay(50,false,this,[v])},scope:this}});this.UI.rotateBtn=new Ext.Button({iconCls:"fa-redo",tooltip:"Rotate",handler:function(){var r=parseInt(this.imageWrap.dom.dataset.rotation);if(!r){r=0}r=r+90;this.imageWrap.setStyle("transform","rotate("+r+"deg)");this.imageWrap.dom.dataset.rotation=r},scope:this});if(Ext.isMobile){this.UI.zoomToggle=new Ext.Button({iconCls:"fa-search-plus",tooltip:"Zoom",handler:function(){window.open(this.getFullResURL())},scope:this})}else{this.UI.zoomToggle=new Ext.Button({iconCls:"fa-search-plus",tooltip:"Zoom",enableToggle:true,toggleHandler:function(b,pressed){if(pressed){this.initZoom()}else{this.cancelZoom()}},scope:this,menu:[this.UI.zoomSlider]})}this.detailsBtn=new Ext.Button({iconCls:"fa-info-circle",tooltip:"Info",scope:this,hidden:!FR.UI.layout.viewerInfoPanel.collapsed,handler:this.openDetails});this.downloadBtn=new Ext.Button({iconCls:"fa-download",tooltip:"Download",hidden:true,handler:function(){FR.actions.download([this.file.path])},scope:this});this.fullScreenBtn=new Ext.Button({iconCls:"fa-expand",handler:function(){var frame=this.previewFrame&&this.file.filetype!="wvideo"?this.previewFrame.dom:document.documentElement;screenfull.toggle(frame)},scope:this,hidden:!screenfull.isEnabled,tooltip:"Fullscreen"});this.editBtn=new Ext.Button({iconCls:"fa-edit",handler:function(){this.loadPage("?module=fileman&section=utils&page=file_edit")},scope:this,hidden:true,tooltip:"Edit"});this.moreBtn=new Ext.Button({iconCls:"fa-ellipsis-v",tooltip:"More actions",handler:function(btn){FR.UI.gridPanel.highlightByRecord(this.files.itemAt(this.currentIndex));FR.UI.gridPanel.showContextMenu(btn.el);return false},scope:this});this.closeBtn={iconCls:"fa-arrow-left",handler:this.close,scope:this,tooltip:"Close"};this.UI.navLeft=new Ext.Button({cls:"fr-prv-nav-btn",iconCls:"fa-chevron-left",tooltip:"Previous file",handler:this.previous,scope:this});this.UI.navRight=new Ext.Button({cls:"fr-prv-nav-btn",iconCls:"fa-chevron-right",tooltip:"Next file",handler:this.next,scope:this});var tbarItems;var bbarCfg={cls:"fr-prv-tbar",items:[this.UI.navLeft,this.UI.status,this.UI.navRight]};if(FR.UI.layout.isPhone){tbarItems=[this.closeBtn,"->",this.downloadBtn,this.UI.zoomToggle,this.UI.rotateBtn,this.editBtn,this.moreBtn,this.fullScreenBtn,this.detailsBtn];bbarCfg.items.unshift("->");bbarCfg.items.unshift(this.UI.filename)}else{bbarCfg.buttonAlign="center";tbarItems=[this.closeBtn,this.UI.filename,"->",this.UI.rotateBtn,this.UI.zoomSlider,this.UI.zoomToggle,this.editBtn,this.fullScreenBtn,this.downloadBtn,this.moreBtn,this.detailsBtn]}this.bottomTBar=new Ext.Toolbar(bbarCfg);this.topTBar=new Ext.Toolbar({cls:"fr-prv-tbar top",style:"min-height:"+FR.UI.layout.northBarsHeight+"px",items:tbarItems});this.items=[{region:"center",unstyled:true,tbar:this.topTBar,bbar:this.bottomTBar,ref:"canvas",bodyCssClass:"canvas"}];var l=FR.UI.layout.viewerInfoPanel;this.infoPanel=new FR.components.infoPanel({region:"east",id:"ImageViewerInfoPanel",split:true,detailsPanelOptions:{hidePreview:true},minWidth:l.minWidth,maxWidth:500,width:l.width,collapsed:l.collapsed,stateful:!l.float,autoHide:false,collapseAction:"closeDetails",closeDetails:function(){FR.UI.ImageViewer.closeDetails()},listeners:{expand:function(){this.detailsBtn.hide();this.infoPanel.refresh(this.file)},scope:this,collapse:function(){this.detailsBtn.show()},slideout:function(region){if(!this.modalMaskCenter){this.modalMaskCenter=new Ext.Mask({targetEl:region.layout.center.el,autoShow:false,onClick:this.infoPanel.closeDetails})}this.modalMaskCenter.show();this.infoPanel.refresh(this.file)},slidein:function(region){this.modalMaskCenter.hide()}}});this.items.push(this.infoPanel);Ext.apply(this,{listeners:{afterrender:function(){this.spinner=this.canvas.body.createChild({tag:"img",src:"images/loading.svg",cls:"spinner"});this.imageWrap=this.canvas.body.createChild({tag:"div",cls:"centered activeImage"});this.setupKeys()},resize:function(){this.cancelZoom()},show:function(){this.nav.enable()},hide:function(){this.imageWrap.update("");this.imageWrap.setStyle("background-image","none");this.files.clear();this.cached.clear();this.nav.disable();if(!FR.UI.layout.isSmall){this.fullScreenBtn.toggle(false,true)}}},scope:this});FR.components.ImageViewer.superclass.initComponent.apply(this,arguments)},initTasks:function(){this.applyZoom=new Ext.util.DelayedTask(function(v){this.imageWrap.setHeight(v).setWidth(v).center(this.canvas.body.dom)},this);this.preloadFollowingHiRes=new Ext.util.DelayedTask(function(){var followingIndex=this.getFollowingIndex();if(followingIndex===false){return false}var followingFile=this.files.itemAt(followingIndex);if(!followingFile){return false}if(this.hasNonImagePreview(followingFile)){return false}var highResSrc=this.getHighResURL(followingFile);if(this.isCached(highResSrc)){return false}if(this.direction=="right"){this.UI.navRight.el.addClass("loading")}else{this.UI.navLeft.el.addClass("loading")}this.prepareImage(followingFile,function(thumbImg){if(!thumbImg||thumbImg.width<this.imageWrap.getWidth()&&thumbImg.height<this.imageWrap.getHeight()){FR.UI.preloadImage(highResSrc,function(success,img,src){if(success){if(this.direction=="right"){this.UI.navRight.el.removeClass("loading")}else{this.UI.navLeft.el.removeClass("loading")}this.cached.add(src,img)}},this)}})},this);this.showSpinner=new Ext.util.DelayedTask(function(){this.spinner.fadeIn()},this);this.loadHiRes=new Ext.util.DelayedTask(function(highResSrc){this.showSpinner.delay(500,false,this);if(this.hasNonImagePreview(this.file)){this.loadPage("?module=fileman&section=utils&page=file_preview&context=viewer");return true}this.previewFrame=false;var cachedImg=this.isCached(highResSrc);if(cachedImg){this.onHiResLoad(cachedImg);return true}this.changed=false;this.preloading=FR.UI.preloadImage(highResSrc,function(success,img,highResSrc){if(this.changed){return false}this.hideSpinner();if(!success){return false}if(!img){return false}this.onHiResLoad(img);this.cached.add(highResSrc,img);this.preloading=false},this)},this)},close:function(){this.cancelHiResLoad();this.cancelPreloading();this.hide();this.infoPanel.tabs.detailsPanel.moreDetailsCache.clear()},canEdit:function(){return this.file.perms.download&&this.file.perms.alter&&FR.utils.isEditable(this.file)},canDownload:function(){return FR.currentSection!="trash"&&this.file.perms.download},setupKeys:function(){var keys={left:function(){this.UI.navLeft.el.addClass("fr-prv-nav-btn-hover");this.previous();(function(){this.UI.navLeft.el.removeClass("fr-prv-nav-btn-hover")}).defer(150,this)},right:function(){this.UI.navRight.el.addClass("fr-prv-nav-btn-hover");(function(){this.UI.navRight.el.removeClass("fr-prv-nav-btn-hover")}).defer(150,this);this.next()},space:function(){this.next()},up:function(){this.previous()},down:function(){this.next()},esc:function(){this.close()},enter:function(){FR.actions.download([this.file.path])},scope:this};this.nav=new Ext.KeyNav(this.focusEl,keys);this.canvas.bwrap.on("click",function(){this.focus()},this)},openDetails:function(){if(FR.UI.layout.viewerInfoPanel.float){this.layout.east.slideOut()}else{this.infoPanel.expand()}},closeDetails:function(){var r=this.infoPanel;if(r.isSlid){this.layout.east.slideIn()}else{r.collapse()}},initZoom:function(){this.loadHiRes.cancel();if(this.zoomed){return false}this.spinner.show();FR.UI.preloadImage(this.getFullResURL(),function(success,img,src){this.hideSpinner();if(!success){return false}this.UI.zoomSlider.show();this.zoomed=true;var w=this.imageWrap.getWidth();var h=this.imageWrap.getHeight();this.imgDrag=new Ext.dd.DD(this.imageWrap.id,false,{moveOnly:true,scroll:false});this.imageWrap.setStyle("background-size","");this.imageWrap.removeClass("centered").addClass("dragging-zoom").setHeight(h).setWidth(w).center();var nHeight=img.naturalHeight;var nWidth=img.naturalWidth;var min=Math.min(w,h);var max=Math.max(nHeight,nWidth);var current=min+(max-min)/4;this.UI.zoomSlider.setMinValue(min);this.UI.zoomSlider.setMaxValue(max);this.UI.zoomSlider.setValue(current);this.imageWrap.setStyle("background-image","url('"+img.src+"')");this.imageWrap.center(this.canvas.body.dom)},this)},resetRotation:function(){this.imageWrap.dom.dataset.rotation="";this.imageWrap.setStyle("transform","rotate(0deg)")},cancelZoom:function(){if(!this.zoomed){return false}this.imgDrag.destroy();this.imageWrap.removeClass("dragging-zoom").addClass("centered").setStyle("width",null).setStyle("height",null).setStyle("top",null).setStyle("left",null);this.UI.zoomSlider.suspendEvents();this.UI.zoomSlider.setValue(0);this.UI.zoomSlider.resumeEvents();this.UI.zoomSlider.hide();this.UI.zoomToggle.toggle(false,true);this.zoomed=false},onHiResLoad:function(img){this.hideSpinner();FR.UI.setImageToContainer({img:img,container:this.imageWrap,style:"contain"});this.preloadFollowingHiRes.delay(300,false,this)},hasNonImagePreview:function(file){return["img","raw","img2"].indexOf(file.filetype)==-1},hideSpinner:function(){this.spinner.fadeOut({duration:.2});this.showSpinner.cancel()},loadPage:function(url){var action=FR.baseURL+"/"+url;var frameName="preview-frame-"+Ext.id();this.imageWrap.setStyle("background-image","none");this.imageWrap.update("");this.previewFrame=this.imageWrap.createChild({tag:"iframe",name:frameName,width:"100%",height:"100%",allowtransparency:"true"});this.previewFrame.on("load",function(frame){this.hideSpinner();try{if(frame.dom.contentDocument.contentType=="application/json"){var rs=Ext.util.JSON.decode(frame.dom.contentDocument.body.textContent);if(rs&&rs.hasOwnProperty("msg")){new Ext.ux.prompt({text:rs.msg,confirmBtnLabel:"Refresh",closable:true,callback:function(){document.location.reload()}})}}}catch(er){}},this);var post=[{name:"path",value:this.file.path}];if(Ext.isMobile){post.push({name:"mobile",value:"1"})}FR.UI.postToTarget({src:action,post:post},frameName)},cancelPreloading:function(){if(this.preloading){FR.UI.cancelPreloadImage(this.preloading);this.preloading=false}},cancelHiResLoad:function(){this.loadHiRes.cancel();this.cancelPreloading();this.hideSpinner()},getFullResURL:function(){return URLRoot+"/?module=custom_actions&action=open_in_browser&path="+encodeURIComponent(this.file.path)},getHighResURL:function(file){var w=this.imageWrap.getWidth();var h=this.imageWrap.getHeight();if(window.devicePixelRatio>=1.3){w=w*2;h=h*2}return FR.UI.getThumbURL({path:file.path,filesize:file.filesize,extra:"&type=preview&width="+w+"&height="+h})},loadFile:function(r,firstLaunch){this.changed=true;this.cancelHiResLoad();this.canvas.body.toggleClassIf("transparent",["png","svg","gif","ai","psd"].indexOf(r.ext)!=-1);this.resetRotation();this.cancelZoom();this.UI.zoomToggle.hide();this.UI.rotateBtn.hide();this.editBtn.hide();this.downloadBtn.hide();this.UI.filename.setText(r.filename);this.file=r;this.file.perms=FR.getTargetPerms(r.perms);if(this.imgDrag){this.imgDrag.destroy()}this.imageWrap.update("");this.imageWrap.setStyle("background-image","none");var loadHighRes=true;if(firstLaunch&&this.hasNonImagePreview(r)){this.loadPage("?module=fileman&section=utils&page=file_preview&context=viewer");loadHighRes=false}if(loadHighRes){var highResSrc=this.getHighResURL(r);if(this.isCached(highResSrc)){this.loadHiRes.delay(0,false,this,[highResSrc])}else{this.prepareImage(r,function(img){if(!img){this.loadHiRes.delay(0,false,this,[highResSrc])}else{FR.UI.setImageToContainer({img:img,container:this.imageWrap,style:"contain",stretchThreshold:40});if(this.hasNonImagePreview(this.file)||img.width<this.imageWrap.getWidth()&&img.height<this.imageWrap.getHeight()){this.loadHiRes.delay(1e3,false,this,[highResSrc])}}})}}if(r.filetype=="img"){this.UI.rotateBtn.show();this.UI.zoomToggle.show()}if(this.canEdit()){this.editBtn.show();this.editBtn.setIconClass(r.filetype=="img"?"fa-sliders":"fa-edit")}if(this.canDownload()){this.downloadBtn.show()}this.topTBar.doLayout(true);this.infoPanel.refresh(r)},prepareImage:function(r,callback){if(!r.thumbURL||!r.thumbLoaded){callback.createDelegate(this,[false])()}else{if(!r.thumbURL){r.thumbURL=FR.UI.getThumbURL(Ext.copyTo({},r,"path,filesize,modified"))}FR.UI.preloadImage(r.thumbURL,function(success,loaded){if(success){callback.createDelegate(this,[loaded])()}},this)}},isCached:function(url){return this.cached.item(url)},setFile:function(index,direction){this.direction=direction||false;var record=this.files.itemAt(index);if(!record){return false}this.currentIndex=index;var count=this.files.getCount();if(count>1&&index!=count-1){this.UI.navRight.enable()}else{this.UI.navRight.disable()}if(count>1&&index!=0){this.UI.navLeft.enable()}else{this.UI.navLeft.disable()}var status="&nbsp;";if(count>1){status=FR.T("%1 / %2").replace("%1",this.currentIndex+1).replace("%2",count)}this.UI.status.setText(status);this.loadFile(record,index==this.startIndex)},previous:function(){var index=this.files.getCount()-1;if(this.currentIndex>0){index=this.currentIndex-1}this.setFile(index,"left")},getFollowingIndex:function(){var count=this.files.getCount();if(this.direction=="right"){if(this.currentIndex<count-1){return this.currentIndex+1}return 0}else if(this.direction=="left"){if(this.currentIndex>0){return this.currentIndex-1}return count-1}return false},next:function(){var index=0;if(this.currentIndex<this.files.getCount()-1){index=this.currentIndex+1}this.setFile(index,"right")},open:function(selectedFile){this.collectFiles(selectedFile);if(this.startIndex==-1){return false}if(!FR.UI.layout.isPhone){this.canvas.getBottomToolbar().setVisible(this.files.length>1)}this.show();this.el.toggleClassIf("fr-layout-small",FR.UI.layout.isSmall);this.setFile(this.startIndex)},collectFiles:function(startFile){this.files.clear();var grid=FR.UI.gridPanel;var selectionPool=grid.countSel>1?grid.selModel:grid.store;selectionPool.each(function(record){if(FR.utils.supportsImageViewer(record.data)){var c=this.files.getCount();this.files.add(c,record.data);if(startFile.uniqid==record.data.uniqid){this.startIndex=c}}},this)},applyFileUpdates:function(path,updates){if(this.infoPanel.fileInfo&&this.infoPanel.fileInfo.path==path){if(updates.filename){this.UI.filename.setText(updates.filename)}}this.infoPanel.applyFileUpdates(path,updates)}});