<?php
	include_once('../config.php');
	$shanchu = $_SESSION['shanchu'];
	$xiugai = $_SESSION['xiugai'];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>資產查詢</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <link rel="stylesheet" href="../lib/layui-v2.5.5/css/layui.css" media="all">
    <link rel="stylesheet" href="../css/public.css" media="all">
	<link rel="stylesheet" href="/js/lay-module/soulTable.css" media="all">
	<link rel="stylesheet" href="../lib/font-awesome-4.7.0/css/font-awesome.min.css" media="all">
	<script>
		function showimg(t) {
			layer.open({
				type: 1,
				title: false,
				closeBtn: 0,
				area: '680px',
				skin: 'layui-layer-nobg',
				shadeClose: true,
				content: '<img style="display: inline-block; width: 100%; height: 100%;" src="'+t+'">'
			});
		}
	</script>
</head>
<body>
<div class="layuimini-container">
    <div class="layuimini-main">
		<script type="text/html" id="simggs">
			<div>
				<img src="{{d.img}}" width="80px" height="auto" onclick="showimg('{{d.img}}');" />
			</div>
		</script>
		<script type="text/html" id="switchTpl">
			<?php if($xiugai){ ?>
			<i lay-event="xiugai" title="編輯資產" class="fa fa-edit"></i>
			&nbsp;&nbsp;
			<?php } ?>
			<i lay-event="rizhi" title="資產履歷" class="fa fa-list-alt"></i>
		</script>
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
    </div>
</div>
<script src="../lib/layui-v2.5.5/layui.js" charset="utf-8"></script>
<script src="../js/lay-config.js?v=1.0.4" charset="utf-8"></script>
<script>


    layui.use(['form', 'table','soulTable'], function () {
        var $ = layui.jquery,
            form = layui.form,
			soulTable = layui.soulTable,
            table = layui.table;

        table.render({
            elem: '#currentTableId',
            url: '../action.php?mode=searchzichan&dw=3',
            toolbar: '#toolbarDemo',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '匯出全部',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-download-circle'
            }]
			,height:'full-200'
        ,overflow: {
            type: 'tips'
            ,hoverTime: 300 // 懸停時間，單位ms, 懸停 hoverTime 後才會顯示，預設為 0
            ,color: 'white' // 字體顏色
            ,bgColor: 'blue' // 背景色
            ,minWidth: 100 // 最小寬度
            ,maxWidth: 500 // 最大寬度
        }
	  ,rowDrag: {trigger: 'row', done: function(obj) {
			//拖拽行
			// 完成時（鬆開時）觸發
			// 如果拖動前和拖動後無變化，則不會觸發此方法
			console.log(obj.row) // 當前行資料
			console.log(obj.cache) // 改動後全表資料
			console.log(obj.oldIndex) // 原來的資料索引
			console.log(obj.newIndex) // 改動後資料索引
		}},	
            cols: [[
                //{type: "checkbox", width: 50, fixed: "left"},
                {field: 'id', width: 80, title: 'ID', sort: true, align: "center"},
                {field: 'zclx', width: 120, title: '資產類型', align: "center", filter: true},
				{field: 'zcbh', width: 150, title: '資產編號', align: "center"},
				{field: 'xlh', width: 150, title: '序號', align: "center"},
				{field: 'zczt', width: 120, title: '資產狀態', align: "center", filter: true},
				{field: 'bm', width: 120, title: '所屬單位', align: "center", filter: true},
				{field: 'bgr', width: 100, title: '責任人', align: "center"},
				{field: 'dz', width: 120, title: '存放地點', align: "center"},
				{field: 'pp', width: 100, title: '品牌', align: "center", filter: true},
				{field: 'xh', width: 100, title: '型號', align: "center"},
				{field: 'gg', width: 90, title: '規格', align: "center"},
				{field: 'cgsj', width: 140, title: '採購時間', align: "center"},
				{field: 'rzsj', width: 140, title: '入帳時間', align: "center"},
				{field: 'zcly', width: 90, title: '資產來源', align: "center"},
				{field: 'zcjz', width: 100, title: '資產價值', align: "center"},
				{field: 'zbsc', width: 90, title: '質保時長', align: "center"},
				{field: 'sysc', width: 90, title: '報廢年限', align: "center"},
				{field: 'img', width: 120, title: '資產圖片', align: "center", templet: "#simggs"},
				{field: 'bz', width: 200, title: '備註', align: "center"},
                {fixed: 'right', width: 100, title: '操作', sort: true, templet: '#switchTpl', align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 10,
            page: true
			
			
			  ,autoColumnWidth: {
			  	init: true
			  }
			  ,filter: {
				items:['column','data','clearCache']
				,cache: true
				,bottom: false 
			  }
			  ,done: function () {
				soulTable.render(this)
			  }
			  
			  
        });
		
        table.on('tool(currentTableFilter)', function (obj) {
            var id = obj.data.id;
			console.log(id);
            if (obj.event === 'xiugai') {
                layer.open({
                    title: '編輯資產',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '/page/editzichan.php?zz=wgbzichan&id='+id,
                });
                return false;
            } else if (obj.event === 'rizhi') {
                layer.open({
                    title: '資產履歷',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '/page/zichanlvli.php?zz=wgbzichan&id='+id,
                });
                return false;
            }
        });

		  table.on('toolbar(currentTableFilter)', function(obj){
			var checkStatus = table.checkStatus(obj.config.id);
			switch(obj.event){
			  case 'LAYTABLE_TIPS':
				location.href="../action.php?mode=downloadzclist&zz=wgbzichan";
			  break;
			};
		  });
    });
	



</script>
</body>
</html>
