
<?php
   
   $afile = uploadfile();
   echo($afile);
   function uploadfile($path="uploads",
    $allowExt = array('png','jpg','jpeg','gif','bmp'),
    $maxSize=5240880,$imgFlag=true){

	$result_arr = array();

    if (! file_exists($path)) {
        mkdir($path,0777,true);
    }
    $i = 0;
    $infoArr = buildInfo();
    foreach ($infoArr as $val) {
        if ($val['error'] === UPLOAD_ERR_OK) {
			$h = false;
            $ext = getExt($val['name']);
            for($j=0;$j<count($allowExt);$j++){
                if($ext == $allowExt[$j]){
                    //$m = "此檔適合上傳標準";
                    $h = true;
                }else {
                    //$m = "此檔不可以被上傳";
                }
            }
            if($h){
                $mes = "檔案格式正確";
            }else{
                $mes = "檔案格式錯誤";
				array_push($result_arr,array("status"=>-1,"msg"=>"檔案格式錯誤"));
                continue; 
            }
            if($val['size']>$maxSize){
                $mes = "文件太大了";
				array_push($result_arr,array("status"=>-2,"msg"=>"文件太大了"));
                continue; 
            }
            if($imgFlag){
                $result = getimagesize($val['tmp_name']);
                if(!$result){
                    $mes = "您上傳的不是一個真正圖片";
					array_push($result_arr,array("status"=>-3,"msg"=>"不是圖片"));
                    continue; 
                }
            }
            if(!is_uploaded_file($val['tmp_name'])){
               $mes = "不是通過httppost傳輸的";
			   array_push($result_arr,array("status"=>-4,"msg"=>"非法訪問"));
               continue; 
            }

            $realName = md5($val['tmp_name'].microtime()).".".$ext;
            $destination = $path."/".$realName;
            if(move_uploaded_file($val['tmp_name'], $destination)){
                $val['name'] = $realName;
                unset($val['error'],$val['tmp_name'],$val['size'],$val['type']);

                //$uploadedFiles[$i]=$val;//
				array_push($result_arr,array("status"=>1,"msg"=>"上傳成功","file"=>$realName));
                $i++;
            }
        }else {
            switch ($val['error']) {
                case 1: // UPLOAD_ERR_INI_SIZE
                    $mes = "超過設定檔中上傳文件的大小";
					$zt = -5;
                    break;
                case 2: // UPLOAD_ERR_FORM_SIZE
                    $mes = "超過表單中設定檔的大小";
					$zt = -6;
                    break;
                case 3: // UPLOAD_ERR_PARTIAL
                    $mes = "檔被部分上傳";
					$zt = -7;
                    break;
                case 4: // UPLOAD_ERR_NO_FILE
                    $mes = "沒有檔被上傳";
					$zt = -8;
                    break;
                case 6: // UPLOAD_ERR_NO_TMP_DIR
                    $mes = "沒有找到臨事檔目錄";
					$zt = -9;
                    break;
                case 7: // UPLOAD_ERR_CANT_WRITE
                    $mes = "文件不可寫";
					$zt = -10;
                    break;
                case 8: // UPLOAD_ERR_EXTENSION
                    $mes = "php擴展程式中斷了上傳程式";
					$zt = -11;
                    break;
            }
            array_push($result_arr,array("status"=>$zt,"msg"=>$mes));
        }
    }

    return json_encode($result_arr);
}

   
   
   function buildInfo(){
//     $info = $_FILES;
    $i = 0;
    foreach ($_FILES as $v){//三維陣列轉換成2維陣列
        if(is_string($v['name'])){ //單文件上傳
            $info[$i] = $v;
            //$i++;
        }else{ // 多文件上傳
            foreach ($v['name'] as $key=>$val){//2維陣列轉換成1維陣列
                //取出一維陣列的值，然後形成另一個陣列
                //新的陣列的結構為：info=>i=>('name','size'.....)
                $info[$i]['name'] = $v['name'][$key];
                $info[$i]['size'] = $v['size'][$key];
                $info[$i]['type'] = $v['type'][$key];
                $info[$i]['tmp_name'] = $v['tmp_name'][$key];
                $info[$i]['error'] = $v['error'][$key];
                $i++;
            }
        }
    }
    return $info;
}


/**
 * 得到檔的副檔名
 * @param unknown $fileName
 * @return string
 */
function getExt($fileName){
	$a=explode('.',$fileName);
	$b=end($a);
	$c=strtolower($b);
    return $c;
    /**
     * strtolower() 函數把字串轉換為小寫。
     * end()輸出陣列中最後一個元素的值
     * explode(),拆分字串
     */
}

?>
